/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectservicebus.sdk;

import com.fifa.connectservicebus.sdk.AuthenticationException;
import com.fifa.connectservicebus.sdk.ConnectServiceBusEnvironment;
import com.fifa.connectservicebus.sdk.FifaConnectServiceBusException;
import com.fifa.connectservicebus.sdk.HttpClientFactory;
import com.fifa.connectservicebus.sdk.OkHttpClientAdapter;
import com.fifa.connectservicebus.sdk.ProxySettings;
import com.fifa.connectservicebus.sdk.ServiceBusResponseHandler;
import com.fifa.connectservicebus.sdk.authentication.AuthenticationInformation;
import com.fifa.connectservicebus.sdk.authentication.AuthenticationInterceptor;
import com.fifa.connectservicebus.sdk.authentication.AuthenticationResourceBuilder;
import com.fifa.connectservicebus.sdk.authentication.AuthenticationService;
import com.fifa.connectservicebus.sdk.authentication.AuthenticationServiceImpl;
import com.fifa.connectservicebus.sdk.authentication.ClientCredentials;
import com.fifa.connectservicebus.sdk.authentication.ConnectServiceBusAuthenticationResourceBuilderImpl;
import com.fifa.connectservicebus.sdk.enhancements.ExceptionExtensions;
import com.fifa.connectservicebus.sdk.logging.Logger;
import com.microsoft.aad.msal4j.MsalServiceException;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class BaseFifaConnectServiceBusClient {
    protected ServiceBusResponseHandler responseHandler = new ServiceBusResponseHandler();
    protected Logger logger;
    private static final Duration REQUEST_TIMEOUT = Duration.ofSeconds(240L);

    protected BaseFifaConnectServiceBusClient(Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("logger parameter cannot be null");
        }
        this.logger = logger;
    }

    protected FifaConnectServiceBusException handleRestClientException(RuntimeException exception) {
        if (ExceptionExtensions.containsSpecificInnerException(exception, MsalServiceException.class)) {
            return new AuthenticationException("Authentication failed", exception);
        }
        return new FifaConnectServiceBusException(exception);
    }

    protected Retrofit ConfigureRetrofit(ConnectServiceBusEnvironment environment, AuthenticationService authenticationService, ProxySettings proxySettings) {
        OkHttpClient client = HttpClientFactory.create(proxySettings, REQUEST_TIMEOUT, builder -> builder.addInterceptor((Interceptor)new AuthenticationInterceptor(authenticationService)));
        return new Retrofit.Builder().baseUrl(environment.getServiceUrl()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).addCallAdapterFactory((CallAdapter.Factory)RxJavaCallAdapterFactory.create()).client(client).build();
    }

    protected static AuthenticationServiceImpl createAuthenticationService(ConnectServiceBusEnvironment environment, ClientCredentials clientCredentials, ProxySettings proxySettings, ExecutorService executorService) {
        return BaseFifaConnectServiceBusClient.createAuthenticationService(environment, clientCredentials, proxySettings, executorService, new ConnectServiceBusAuthenticationResourceBuilderImpl());
    }

    protected static AuthenticationServiceImpl createAuthenticationService(ConnectServiceBusEnvironment environment, ClientCredentials clientCredentials, ProxySettings proxySettings, ExecutorService executorService, AuthenticationResourceBuilder authenticationResourceBuilder) {
        if (clientCredentials == null) {
            throw new IllegalArgumentException("clientCredentials parameter cannot be null");
        }
        AuthenticationInformation authenticationInformation = new AuthenticationInformation(authenticationResourceBuilder, clientCredentials, URI.create(environment.getServiceUrl()), environment.getTenant());
        OkHttpClient client = HttpClientFactory.create(proxySettings, REQUEST_TIMEOUT);
        OkHttpClientAdapter adapter = new OkHttpClientAdapter(client);
        return new AuthenticationServiceImpl(authenticationInformation, adapter, executorService);
    }
}

