/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectservicebus.sdk;

import com.fifa.connectservicebus.sdk.AuthenticationException;
import com.fifa.connectservicebus.sdk.BaseFifaConnectServiceBusClient;
import com.fifa.connectservicebus.sdk.ConnectServiceBusEnvironment;
import com.fifa.connectservicebus.sdk.FifaConnectServiceBusCertificateClient;
import com.fifa.connectservicebus.sdk.FifaConnectServiceBusException;
import com.fifa.connectservicebus.sdk.ProxySettings;
import com.fifa.connectservicebus.sdk.StringUtils;
import com.fifa.connectservicebus.sdk.UnauthorizedException;
import com.fifa.connectservicebus.sdk.api.Certificates;
import com.fifa.connectservicebus.sdk.api.implementation.CertificatesImpl;
import com.fifa.connectservicebus.sdk.api.implementation.FIFAConnectServiceBusV3Impl;
import com.fifa.connectservicebus.sdk.authentication.AuthenticationService;
import com.fifa.connectservicebus.sdk.authentication.ClientCredentials;
import com.fifa.connectservicebus.sdk.errorhandling.DataNotFoundResponseHandler;
import com.fifa.connectservicebus.sdk.errorhandling.ErrorResponseHandler;
import com.fifa.connectservicebus.sdk.logging.Logger;
import com.microsoft.rest.ServiceResponse;
import java.util.concurrent.ExecutorService;
import retrofit2.Retrofit;

public class FifaConnectServiceBusCertificateClientImpl
extends BaseFifaConnectServiceBusClient
implements FifaConnectServiceBusCertificateClient {
    private final Certificates certificateOperations;

    public FifaConnectServiceBusCertificateClientImpl(Certificates certificateOperations, Logger logger) {
        super(logger);
        if (certificateOperations == null) {
            throw new IllegalArgumentException("certificateOperations parameter cannot be null");
        }
        this.certificateOperations = certificateOperations;
    }

    public FifaConnectServiceBusCertificateClientImpl(ConnectServiceBusEnvironment environment, ClientCredentials clientCredentials, Logger logger) {
        this(environment, FifaConnectServiceBusCertificateClientImpl.createAuthenticationService(environment, clientCredentials, ProxySettings.empty(), null), logger, ProxySettings.empty());
    }

    public FifaConnectServiceBusCertificateClientImpl(ConnectServiceBusEnvironment environment, ClientCredentials clientCredentials, Logger logger, ProxySettings proxySettings) {
        this(environment, FifaConnectServiceBusCertificateClientImpl.createAuthenticationService(environment, clientCredentials, proxySettings, null), logger, proxySettings);
    }

    public FifaConnectServiceBusCertificateClientImpl(ConnectServiceBusEnvironment environment, ClientCredentials clientCredentials, Logger logger, ProxySettings proxySettings, ExecutorService executorService) {
        this(environment, FifaConnectServiceBusCertificateClientImpl.createAuthenticationService(environment, clientCredentials, proxySettings, executorService), logger, proxySettings);
    }

    public FifaConnectServiceBusCertificateClientImpl(ConnectServiceBusEnvironment environment, AuthenticationService authenticationService, Logger logger) {
        this(environment, authenticationService, logger, ProxySettings.empty());
    }

    public FifaConnectServiceBusCertificateClientImpl(ConnectServiceBusEnvironment environment, AuthenticationService authenticationService, Logger logger, ProxySettings proxySettings) {
        super(logger);
        if (environment == null) {
            throw new IllegalArgumentException("environment parameter cannot be null");
        }
        if (authenticationService == null) {
            throw new IllegalArgumentException("authenticationService parameter cannot be null");
        }
        Retrofit retrofit = this.ConfigureRetrofit(environment, authenticationService, proxySettings);
        this.certificateOperations = new CertificatesImpl(retrofit, new FIFAConnectServiceBusV3Impl(environment.getServiceUrl()));
    }

    @Override
    public void uploadCertificate(byte[] certificate) throws FifaConnectServiceBusException, IllegalArgumentException, AuthenticationException, UnauthorizedException {
        if (certificate == null || certificate.length == 0) {
            throw new IllegalArgumentException("certificate");
        }
        try {
            ServiceResponse response;
            this.logger.debug("Uploading certificate", new Object[0]);
            try {
                response = (ServiceResponse)this.certificateOperations.uploadWithServiceResponseAsync(certificate).toBlocking().single();
            }
            catch (RuntimeException exception) {
                throw this.handleRestClientException(exception);
            }
            this.logger.debug(String.format("Received response from certificate upload with status %s", response.response().code()), response.response());
            this.responseHandler.processResult(200, response, new ErrorResponseHandler[0]);
            this.logger.debug("Certificate was successfully uploaded", new Object[0]);
        }
        catch (Exception e) {
            this.logger.error(e, "Unexpected error when trying to upload a certificate", new Object[0]);
            throw e;
        }
    }

    @Override
    public byte[] downloadCertificate(String queueIdentifier) throws FifaConnectServiceBusException, AuthenticationException, UnauthorizedException {
        if (StringUtils.isNullOrEmpty(queueIdentifier)) {
            throw new IllegalArgumentException("queueIdentifier");
        }
        try {
            ServiceResponse response;
            this.logger.debug("Getting certificate for queue %s", queueIdentifier);
            try {
                response = (ServiceResponse)this.certificateOperations.downloadByQueueidentifierWithServiceResponseAsync(queueIdentifier).toBlocking().single();
            }
            catch (RuntimeException exception) {
                throw this.handleRestClientException(exception);
            }
            int responseCode = response.response().code();
            this.logger.debug("Response received from downloading certificate for queue %s with code %s", queueIdentifier, Integer.toString(responseCode), response.response());
            byte[] result = this.responseHandler.processResult(byte[].class, 200, response, new DataNotFoundResponseHandler());
            this.logger.debug(String.format("Public certificate for queue '%s' was downloaded successfully", queueIdentifier), new Object[0]);
            return result;
        }
        catch (Exception e) {
            this.logger.error(e, "Unexpected error when trying to download a certificate", new Object[0]);
            throw e;
        }
    }
}

