/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectservicebus.sdk;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fifa.connectservicebus.sdk.AuthenticationException;
import com.fifa.connectservicebus.sdk.BaseFifaConnectServiceBusClient;
import com.fifa.connectservicebus.sdk.ConnectServiceBusEnvironment;
import com.fifa.connectservicebus.sdk.CryptographyException;
import com.fifa.connectservicebus.sdk.FifaConnectServiceBusCertificateClientImpl;
import com.fifa.connectservicebus.sdk.FifaConnectServiceBusClient;
import com.fifa.connectservicebus.sdk.FifaConnectServiceBusException;
import com.fifa.connectservicebus.sdk.Message;
import com.fifa.connectservicebus.sdk.ProxySettings;
import com.fifa.connectservicebus.sdk.QueueNotFoundException;
import com.fifa.connectservicebus.sdk.StringUtils;
import com.fifa.connectservicebus.sdk.UnauthorizedException;
import com.fifa.connectservicebus.sdk.api.Messages;
import com.fifa.connectservicebus.sdk.api.implementation.FIFAConnectServiceBusV3Impl;
import com.fifa.connectservicebus.sdk.api.implementation.MessagesImpl;
import com.fifa.connectservicebus.sdk.api.models.MessagePeekLockByRequestHeaders;
import com.fifa.connectservicebus.sdk.authentication.AuthenticationService;
import com.fifa.connectservicebus.sdk.authentication.AuthenticationServiceImpl;
import com.fifa.connectservicebus.sdk.authentication.ClientCredentials;
import com.fifa.connectservicebus.sdk.encryption.CertificateBasedCryptographyAlgorithm;
import com.fifa.connectservicebus.sdk.encryption.CryptographyAlgorithm;
import com.fifa.connectservicebus.sdk.encryption.EncryptionResult;
import com.fifa.connectservicebus.sdk.encryption.MemoryBasedPublicCertificateProvider;
import com.fifa.connectservicebus.sdk.encryption.MessageCryptographyService;
import com.fifa.connectservicebus.sdk.encryption.MessageCryptographyServiceImpl;
import com.fifa.connectservicebus.sdk.encryption.PrivateKeyStorage;
import com.fifa.connectservicebus.sdk.encryption.PublicCertificateNotFoundException;
import com.fifa.connectservicebus.sdk.encryption.RSACryptographyService;
import com.fifa.connectservicebus.sdk.errorhandling.ErrorResponseHandler;
import com.fifa.connectservicebus.sdk.errorhandling.QueueNotFoundResponseHandler;
import com.fifa.connectservicebus.sdk.logging.Logger;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.ServiceResponseWithHeaders;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import retrofit2.Retrofit;

public class FifaConnectServiceBusClientImpl
extends BaseFifaConnectServiceBusClient
implements FifaConnectServiceBusClient {
    private final int defaultTimeoutInSeconds = 60;
    private Messages messageOperations;
    private MessageCryptographyService cryptographyService;
    private boolean useEncryption = true;

    public FifaConnectServiceBusClientImpl(Messages messageOperations, MessageCryptographyService cryptographyService, Logger logger) {
        super(logger);
        if (messageOperations == null) {
            throw new IllegalArgumentException("messageOperations parameter cannot be null");
        }
        if (cryptographyService == null) {
            throw new IllegalArgumentException("cryptographyService parameter cannot be null");
        }
        this.messageOperations = messageOperations;
        this.cryptographyService = cryptographyService;
    }

    public FifaConnectServiceBusClientImpl(ConnectServiceBusEnvironment environment, ClientCredentials clientCredentials, MessageCryptographyService cryptographyService, Logger logger) {
        super(logger);
        ProxySettings proxySettings = ProxySettings.empty();
        AuthenticationServiceImpl authenticationService = FifaConnectServiceBusClientImpl.createAuthenticationService(environment, clientCredentials, proxySettings, null);
        this.SetUp(environment, authenticationService, cryptographyService, proxySettings);
    }

    public FifaConnectServiceBusClientImpl(ConnectServiceBusEnvironment environment, ClientCredentials clientCredentials, PrivateKeyStorage privateKeyStorage, Logger logger) {
        super(logger);
        ProxySettings proxySettings = ProxySettings.empty();
        AuthenticationServiceImpl authenticationService = FifaConnectServiceBusClientImpl.createAuthenticationService(environment, clientCredentials, proxySettings, null);
        MessageCryptographyService cryptographyService = FifaConnectServiceBusClientImpl.buildMessageCryptographyService(environment, clientCredentials, privateKeyStorage, logger, proxySettings, null);
        this.SetUp(environment, authenticationService, cryptographyService, proxySettings);
    }

    public FifaConnectServiceBusClientImpl(ConnectServiceBusEnvironment environment, ClientCredentials clientCredentials, PrivateKeyStorage privateKeyStorage, Logger logger, ProxySettings proxySettings) {
        this(environment, clientCredentials, privateKeyStorage, logger, proxySettings, null);
    }

    public FifaConnectServiceBusClientImpl(ConnectServiceBusEnvironment environment, ClientCredentials clientCredentials, PrivateKeyStorage privateKeyStorage, Logger logger, ProxySettings proxySettings, ExecutorService executorService) {
        super(logger);
        AuthenticationServiceImpl authenticationService = FifaConnectServiceBusClientImpl.createAuthenticationService(environment, clientCredentials, proxySettings, executorService);
        MessageCryptographyService cryptographyService = FifaConnectServiceBusClientImpl.buildMessageCryptographyService(environment, clientCredentials, privateKeyStorage, logger, proxySettings, executorService);
        this.SetUp(environment, authenticationService, cryptographyService, proxySettings);
    }

    public FifaConnectServiceBusClientImpl(ConnectServiceBusEnvironment environment, AuthenticationService authenticationService, MessageCryptographyService cryptographyService, Logger logger) {
        super(logger);
        this.SetUp(environment, authenticationService, cryptographyService, ProxySettings.empty());
    }

    public FifaConnectServiceBusClientImpl(ConnectServiceBusEnvironment environment, AuthenticationService authenticationService, MessageCryptographyService cryptographyService, Logger logger, ProxySettings proxySettings) {
        super(logger);
        this.SetUp(environment, authenticationService, cryptographyService, proxySettings);
    }

    private void SetUp(ConnectServiceBusEnvironment environment, AuthenticationService authenticationService, MessageCryptographyService cryptographyService, ProxySettings proxySettings) {
        if (environment == null) {
            throw new IllegalArgumentException("environment parameter cannot be null");
        }
        if (authenticationService == null) {
            throw new IllegalArgumentException("authenticationService parameter cannot be null");
        }
        if (cryptographyService == null) {
            throw new IllegalArgumentException("cryptographyService parameter cannot be null");
        }
        Retrofit retrofit = this.ConfigureRetrofit(environment, authenticationService, proxySettings);
        this.messageOperations = new MessagesImpl(retrofit, new FIFAConnectServiceBusV3Impl(environment.getServiceUrl()));
        this.cryptographyService = cryptographyService;
    }

    @Override
    public void setUseEncryption(boolean value) {
        this.useEncryption = value;
    }

    @Override
    public boolean getUseEncryption() {
        return this.useEncryption;
    }

    @Override
    public void send(String recipient, byte[] content, String action, Map<String, String> properties) throws FifaConnectServiceBusException, AuthenticationException, UnauthorizedException, PublicCertificateNotFoundException, CryptographyException, QueueNotFoundException {
        if (StringUtils.isNullOrEmpty(recipient)) {
            throw new IllegalArgumentException("recipient");
        }
        if (content == null) {
            content = new byte[]{};
        }
        try {
            ServiceResponse response;
            if (this.useEncryption) {
                this.logger.debug("Encrypting message to be sent to: '%s'", recipient);
                if (properties == null) {
                    properties = new HashMap<String, String>();
                }
                EncryptionResult result = this.cryptographyService.encrypt(content, recipient);
                content = result.data;
                properties.putAll(result.properties);
            } else {
                this.logger.debug("Encryption is turned off - original message is going to be sent to '%s'.", recipient);
            }
            String propertiesString = null;
            if (properties != null) {
                ObjectMapper mapper = new ObjectMapper();
                try {
                    propertiesString = mapper.writeValueAsString(properties);
                }
                catch (JsonProcessingException exception) {
                    throw new FifaConnectServiceBusException("Unable to serialize collection of message properties", exception);
                }
            }
            this.logger.debug("Sending message to: %s", recipient);
            try {
                response = (ServiceResponse)this.messageOperations.sendByRecipientAndActionAndPropertiesWithServiceResponseAsync(recipient, content, action, propertiesString).toBlocking().single();
            }
            catch (RuntimeException exception) {
                throw this.handleRestClientException(exception);
            }
            this.logger.debug("Received response from Connect Service Bus service with status '%d'.", response.response().code());
            this.responseHandler.processResult(201, response, new QueueNotFoundResponseHandler());
        }
        catch (Exception e) {
            this.logger.error(e, "Failed to send message to '%s'", recipient);
            throw e;
        }
    }

    @Override
    public void send(String recipient, byte[] content) throws FifaConnectServiceBusException, AuthenticationException, UnauthorizedException, PublicCertificateNotFoundException, CryptographyException, QueueNotFoundException {
        this.send(recipient, content, null, null);
    }

    @Override
    public Message peekLock(int timeout) throws FifaConnectServiceBusException, AuthenticationException, UnauthorizedException, CryptographyException, QueueNotFoundException {
        try {
            ServiceResponseWithHeaders response;
            this.logger.debug("Trying to peek lock message with timeout: %d ", timeout);
            try {
                response = (ServiceResponseWithHeaders)this.messageOperations.peekLockByRequestWithServiceResponseAsync(timeout).toBlocking().single();
            }
            catch (RuntimeException e) {
                throw this.handleRestClientException(e);
            }
            this.logger.debug("Received response from Connect Service Bus service with status %d.", response.response().code());
            String action = ((MessagePeekLockByRequestHeaders)response.headers()).xAction();
            String messageProperties = ((MessagePeekLockByRequestHeaders)response.headers()).xProperties();
            String brokerProperties = ((MessagePeekLockByRequestHeaders)response.headers()).brokerProperties();
            Message message = this.processPeekLockResponseMessage((ServiceResponse)response, 201, action, messageProperties, brokerProperties);
            if (message == null) {
                return null;
            }
            this.DecryptMessageIfEncrypted(message, message.getProperties());
            return message;
        }
        catch (Exception e) {
            this.logger.error(e, "Failed to PeekLock message", new Object[0]);
            throw e;
        }
    }

    @Override
    public Message peekLock() throws FifaConnectServiceBusException, AuthenticationException, UnauthorizedException, CryptographyException, QueueNotFoundException {
        return this.peekLock(60);
    }

    @Override
    public void delete(String messageId, String lockToken) throws FifaConnectServiceBusException, AuthenticationException, UnauthorizedException {
        if (StringUtils.isNullOrEmpty(messageId)) {
            throw new IllegalArgumentException("messageId");
        }
        if (StringUtils.isNullOrEmpty(lockToken)) {
            throw new IllegalArgumentException("lockToken");
        }
        try {
            ServiceResponse response;
            this.logger.debug("Delete message with id: %s using lock token: %s", messageId, lockToken);
            try {
                response = (ServiceResponse)this.messageOperations.deleteByRequestWithServiceResponseAsync(messageId, lockToken).toBlocking().single();
            }
            catch (RuntimeException exception) {
                throw this.handleRestClientException(exception);
            }
            this.logger.debug("Received response for deleting message with id: %s", messageId);
            this.responseHandler.processResult(200, response, new ErrorResponseHandler[0]);
            this.logger.debug("Message with id: %s deleted successfully", messageId);
        }
        catch (Exception e) {
            this.logger.error(e, "Unexpected error when trying to delete message with id: '%s' using lock token: '%s'", messageId, lockToken);
            throw e;
        }
    }

    @Override
    public void unlock(String messageId, String lockToken) throws FifaConnectServiceBusException, AuthenticationException, UnauthorizedException {
        if (StringUtils.isNullOrEmpty(messageId)) {
            throw new IllegalArgumentException("messageId");
        }
        if (StringUtils.isNullOrEmpty(lockToken)) {
            throw new IllegalArgumentException("lockToken");
        }
        try {
            ServiceResponse response;
            this.logger.debug("Unlock message with id: %s using lock token: %s", messageId, lockToken);
            try {
                response = (ServiceResponse)this.messageOperations.unlockByRequestWithServiceResponseAsync(messageId, lockToken).toBlocking().single();
            }
            catch (RuntimeException exception) {
                throw this.handleRestClientException(exception);
            }
            this.logger.debug("Received response for unlock message with id: %s", messageId);
            this.responseHandler.processResult(200, response, new ErrorResponseHandler[0]);
            this.logger.debug("Message with id: %s unlocked successfully", messageId);
        }
        catch (Exception e) {
            this.logger.error(e, "Unexpected error when trying to unlock message with id: '%s' using lock token: '%s'", messageId, lockToken);
            throw e;
        }
    }

    private void DecryptMessageIfEncrypted(Message message, Map<String, String> properties) throws CryptographyException {
        boolean isEncryptionUsed;
        boolean bl = isEncryptionUsed = properties != null && properties.containsKey("EncryptionVersion");
        if (isEncryptionUsed) {
            this.logger.debug("Message received from '%s' appears to be encrypted. It will be now decrypted.", message.getSender());
            message.setContent(this.cryptographyService.decrypt(message));
        } else {
            this.logger.debug("Message received from '%s' does not appear to be encrypted. Original content is going to be returned.", message.getSender());
        }
    }

    private static MessageCryptographyService buildMessageCryptographyService(ConnectServiceBusEnvironment environment, ClientCredentials clientCredentials, PrivateKeyStorage privateKeyStorage, Logger logger, ProxySettings proxySettings, ExecutorService executorService) {
        FifaConnectServiceBusCertificateClientImpl certificateClient = new FifaConnectServiceBusCertificateClientImpl(environment, clientCredentials, logger, proxySettings, executorService);
        MemoryBasedPublicCertificateProvider publicCertificateProvider = new MemoryBasedPublicCertificateProvider(certificateClient, Duration.ofDays(1L));
        ArrayList<CryptographyAlgorithm> algorithms = new ArrayList<CryptographyAlgorithm>();
        algorithms.add(new CertificateBasedCryptographyAlgorithm(new RSACryptographyService(publicCertificateProvider, privateKeyStorage, logger), logger));
        MessageCryptographyServiceImpl cryptographyService = new MessageCryptographyServiceImpl(algorithms, logger);
        return cryptographyService;
    }

    protected Message processPeekLockResponseMessage(ServiceResponse response, int successStatusCode, String action, String messagePropertiesString, String brokerPropertiesString) throws FifaConnectServiceBusException {
        int responseCode = response.response().code();
        if (responseCode == 204) {
            this.logger.debug("There was no message for: %s", response.response().raw().request().url());
            return null;
        }
        byte[] messageContent = this.responseHandler.processResult(byte[].class, successStatusCode, response, new QueueNotFoundResponseHandler());
        ObjectMapper mapper = new ObjectMapper();
        HashMap<String, String> messageProperties = new HashMap();
        HashMap<String, Object> brokerProperties = new HashMap();
        try {
            if (messagePropertiesString != null) {
                messageProperties = (Map)mapper.readValue(messagePropertiesString, new HashMap().getClass());
            }
            if (brokerPropertiesString != null) {
                brokerProperties = (Map)mapper.readValue(brokerPropertiesString, new HashMap().getClass());
            }
        }
        catch (IOException e) {
            throw new FifaConnectServiceBusException("Failed to read properties", e);
        }
        Message message = new Message();
        message.setContent(messageContent);
        message.setAction(action);
        message.setProperties(messageProperties);
        message.setBrokerProperties(brokerProperties);
        return message;
    }
}

