/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectservicebus.sdk;

import com.fifa.connectservicebus.sdk.ProxySettings;
import com.fifa.connectservicebus.sdk.enhancements.Action;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.time.Duration;
import okhttp3.OkHttpClient;

public final class HttpClientFactory {
    public static OkHttpClient create(ProxySettings proxySettings, Duration requestTimeout) {
        return HttpClientFactory.create(proxySettings, requestTimeout, null);
    }

    public static OkHttpClient create(ProxySettings proxySettings, Duration requestTimeout, Action<OkHttpClient.Builder> buildAction) {
        OkHttpClient.Builder okClientBuilder = new OkHttpClient.Builder().readTimeout(requestTimeout).connectTimeout(requestTimeout);
        if (!proxySettings.isEmpty()) {
            Proxy proxy = new Proxy(proxySettings.Type, new InetSocketAddress(proxySettings.HostName, proxySettings.Port));
            okClientBuilder.proxy(proxy);
        }
        if (buildAction != null) {
            buildAction.invoke(okClientBuilder);
        }
        return okClientBuilder.build();
    }
}

