/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectservicebus.sdk;

import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class Message {
    private final String lockTokenKey = "LockToken";
    private final String messageIdKey = "MessageId";
    private final String senderKey = "Sender";
    private final String replyToKey = "ReplyTo";
    private byte[] content;
    private String action;
    private Map<String, String> properties;
    private Map<String, Object> brokerProperties;

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Map<String, Object> getBrokerProperties() {
        return this.brokerProperties;
    }

    public void setBrokerProperties(Map<String, Object> brokerProperties) {
        this.brokerProperties = brokerProperties;
    }

    public String getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public Object getBrokerProperty(String propertyName) {
        return this.brokerProperties.get(propertyName);
    }

    public String getId() {
        return this.getStringValue(this.brokerProperties, this.messageIdKey);
    }

    public String getLockToken() {
        return this.getStringValue(this.brokerProperties, this.lockTokenKey);
    }

    public String getSender() {
        return this.getStringValue(this.brokerProperties, this.senderKey);
    }

    public String getReplyTo() {
        return this.getStringValue(this.brokerProperties, this.replyToKey);
    }

    private String getStringValue(Map<String, Object> map, String key) {
        if (map.containsKey(key)) {
            String value = map.get(key).toString();
            return value;
        }
        return null;
    }

    public String toString() {
        int contentLength = this.content == null ? -1 : this.content.length;
        return "Id: " + this.getId() + ", Action: " + this.action + ", ContentLength: " + contentLength + ", Properties: " + Message.dumpDictionary(this.properties) + ", BrokerProperties: " + Message.dumpDictionary(this.brokerProperties);
    }

    private static String dumpDictionary(@NotNull Map<String, ?> map) {
        return map.keySet().stream().map(key -> key + "=" + map.get(key)).collect(Collectors.joining(", "));
    }
}

