/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectservicebus.sdk;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fifa.connectservicebus.sdk.api.models.BadRequestResponseType;
import com.fifa.connectservicebus.sdk.api.models.DeliveryRestrictedResponseType;
import com.fifa.connectservicebus.sdk.api.models.DetailsItemType;
import com.fifa.connectservicebus.sdk.api.models.LockedMessageRequest;
import com.fifa.connectservicebus.sdk.api.models.MessageTimeoutHeaders;
import com.fifa.connectservicebus.sdk.api.models.MessageTimeoutHeaders1;
import com.fifa.connectservicebus.sdk.api.models.TimeoutableMessageRequest;
import com.fifa.connectservicebus.sdk.api.models.TooManyRequestsResponseType;

public class ObjectFormatter {
    public static String toJson(Object obj) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            return "Could not serialize an object.";
        }
    }

    public static String toString(TimeoutableMessageRequest request) {
        return "Timeout: " + request.timeout();
    }

    public static String toString(MessageTimeoutHeaders1 requestHeaders) {
        return "XAction: " + requestHeaders.xAction() + ", XProperties: " + requestHeaders.xProperties() + ", BrokerProperties: " + requestHeaders.brokerProperties();
    }

    public static String toString(DetailsItemType itemType) {
        return "Key: " + itemType.key() + ", Value: " + itemType.value();
    }

    public static String toString(MessageTimeoutHeaders requestHeaders) {
        return "XAction: " + requestHeaders.xAction() + ", XProperties: " + requestHeaders.xProperties() + ", BrokerProperties: " + requestHeaders.brokerProperties();
    }

    public static String toString(BadRequestResponseType type) {
        return "Message: " + type.message() + ", Details: " + ObjectFormatter.toJson(type.details());
    }

    public static String toString(LockedMessageRequest request) {
        return ", LockToken: " + request.lockToken() + ", MessageId: " + request.messageId();
    }

    public static String toString(TooManyRequestsResponseType type) {
        return type.message();
    }

    public static String toString(DeliveryRestrictedResponseType type) {
        return type.message();
    }
}

