/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectservicebus.sdk;

import com.microsoft.aad.msal4j.HttpRequest;
import com.microsoft.aad.msal4j.HttpResponse;
import com.microsoft.aad.msal4j.IHttpClient;
import com.microsoft.aad.msal4j.IHttpResponse;
import java.io.IOException;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.Nullable;

public class OkHttpClientAdapter
implements IHttpClient {
    private final OkHttpClient httpClient;

    public OkHttpClientAdapter(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public IHttpResponse send(HttpRequest httpRequest) throws Exception {
        Request request = this.buildRequest(httpRequest);
        Response okHttpResponse = this.httpClient.newCall(request).execute();
        return this.buildResponse(okHttpResponse);
    }

    private Request buildRequest(HttpRequest httpRequest) {
        return new Request.Builder().headers(Headers.of((Map)httpRequest.headers())).url(httpRequest.url()).method(httpRequest.httpMethod().name(), this.getRequestBody(httpRequest)).build();
    }

    @Nullable
    private RequestBody getRequestBody(HttpRequest httpRequest) {
        String requestBody = httpRequest.body();
        return requestBody != null ? RequestBody.create((byte[])requestBody.getBytes()) : null;
    }

    private IHttpResponse buildResponse(Response okHttpResponse) throws IOException {
        HttpResponse response = new HttpResponse();
        response.addHeaders(okHttpResponse.headers().toMultimap());
        response.body(this.getBodyString(okHttpResponse));
        response.statusCode(okHttpResponse.code());
        return response;
    }

    @Nullable
    private String getBodyString(Response okHttpResponse) throws IOException {
        ResponseBody responseBody = okHttpResponse.body();
        return responseBody != null ? responseBody.string() : null;
    }
}

