/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectservicebus.sdk;

import com.fifa.connectservicebus.sdk.FifaConnectServiceBusException;
import com.fifa.connectservicebus.sdk.errorhandling.BadRequestHandler;
import com.fifa.connectservicebus.sdk.errorhandling.ErrorResponseHandler;
import com.fifa.connectservicebus.sdk.errorhandling.TooManyRequestsHandler;
import com.fifa.connectservicebus.sdk.errorhandling.UnauthorizedRequestHandler;
import com.microsoft.rest.ServiceResponse;
import java.util.ArrayList;
import java.util.List;

public class ServiceBusResponseHandler {
    private List<ErrorResponseHandler> knownHandlers = new ArrayList<ErrorResponseHandler>();

    public ServiceBusResponseHandler() {
        this.knownHandlers.add(new BadRequestHandler());
        this.knownHandlers.add(new UnauthorizedRequestHandler());
        this.knownHandlers.add(new TooManyRequestsHandler());
    }

    public <T> T processResult(Class<T> type, int successStatusCode, ServiceResponse response, ErrorResponseHandler ... handlers) throws FifaConnectServiceBusException {
        int responseCode = response.response().code();
        Object body = response.body();
        if (responseCode == successStatusCode) {
            if (Void.class.isAssignableFrom(type)) {
                return null;
            }
            if (type.isInstance(body)) {
                return (T)body;
            }
        }
        ArrayList<ErrorResponseHandler> allHandlers = new ArrayList<ErrorResponseHandler>();
        allHandlers.addAll(this.knownHandlers);
        for (ErrorResponseHandler handler : handlers) {
            allHandlers.add(handler);
        }
        for (ErrorResponseHandler handler : allHandlers) {
            handler.handle((ServiceResponse<Object>)response);
        }
        String message = ServiceBusResponseHandler.formatGenericMessage(responseCode, response.response().message());
        throw new FifaConnectServiceBusException(message, (ServiceResponse<Object>)response);
    }

    public void processResult(int successStatusCode, ServiceResponse response, ErrorResponseHandler ... handlers) throws FifaConnectServiceBusException {
        this.processResult(Void.class, successStatusCode, response, handlers);
    }

    private static String formatGenericMessage(int statusCode, String message) {
        return String.format("Server responded with status code %d: %s", statusCode, message);
    }
}

