/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectservicebus.sdk.api.implementation;

import com.fifa.connectservicebus.sdk.api.Certificates;
import com.fifa.connectservicebus.sdk.api.implementation.FIFAConnectServiceBusV3Impl;
import com.fifa.connectservicebus.sdk.api.models.BadRequestResponseType;
import com.fifa.connectservicebus.sdk.api.models.TooManyRequestsResponseType;
import com.google.common.reflect.TypeToken;
import com.microsoft.rest.RestException;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class CertificatesImpl
implements Certificates {
    private CertificatesService service;
    private FIFAConnectServiceBusV3Impl client;

    public CertificatesImpl(Retrofit retrofit, FIFAConnectServiceBusV3Impl client) {
        this.service = (CertificatesService)retrofit.create(CertificatesService.class);
        this.client = client;
    }

    @Override
    public Object upload(byte[] body) {
        return ((ServiceResponse)this.uploadWithServiceResponseAsync(body).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> uploadAsync(byte[] body, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.uploadWithServiceResponseAsync(body), serviceCallback);
    }

    @Override
    public Observable<Object> uploadAsync(byte[] body) {
        return this.uploadWithServiceResponseAsync(body).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> uploadWithServiceResponseAsync(byte[] body) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        return this.service.upload(body).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = CertificatesImpl.this.uploadDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Object> uploadDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(401, new TypeToken<Void>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).build(response);
    }

    @Override
    public Object downloadByQueueidentifier(String queueIdentifier) {
        return ((ServiceResponse)this.downloadByQueueidentifierWithServiceResponseAsync(queueIdentifier).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> downloadByQueueidentifierAsync(String queueIdentifier, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.downloadByQueueidentifierWithServiceResponseAsync(queueIdentifier), serviceCallback);
    }

    @Override
    public Observable<Object> downloadByQueueidentifierAsync(String queueIdentifier) {
        return this.downloadByQueueidentifierWithServiceResponseAsync(queueIdentifier).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> downloadByQueueidentifierWithServiceResponseAsync(String queueIdentifier) {
        if (queueIdentifier == null) {
            throw new IllegalArgumentException("Parameter queueIdentifier is required and cannot be null.");
        }
        return this.service.downloadByQueueidentifier(queueIdentifier).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = CertificatesImpl.this.downloadByQueueidentifierDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Object> downloadByQueueidentifierDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<byte[]>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(401, new TypeToken<Void>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).build(response);
    }

    static interface CertificatesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectservicebus.sdk.api.Certificates upload"})
        @POST(value="api/v3/certificate/upload")
        public Observable<Response<ResponseBody>> upload(@Body byte[] var1);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectservicebus.sdk.api.Certificates downloadByQueueidentifier"})
        @GET(value="api/v3/certificate/download")
        public Observable<Response<ResponseBody>> downloadByQueueidentifier(@Query(value="queueIdentifier") String var1);
    }
}

