/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectservicebus.sdk.api.implementation;

import com.fifa.connectservicebus.sdk.api.Messages;
import com.fifa.connectservicebus.sdk.api.implementation.FIFAConnectServiceBusV3Impl;
import com.fifa.connectservicebus.sdk.api.models.BadRequestResponseType;
import com.fifa.connectservicebus.sdk.api.models.DeliveryRestrictedResponseType;
import com.fifa.connectservicebus.sdk.api.models.MessagePeekLockByRequestHeaders;
import com.fifa.connectservicebus.sdk.api.models.MessageReceiveByRequestHeaders;
import com.fifa.connectservicebus.sdk.api.models.TooManyRequestsResponseType;
import com.google.common.reflect.TypeToken;
import com.microsoft.rest.RestException;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.ServiceResponseWithHeaders;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class MessagesImpl
implements Messages {
    private MessagesService service;
    private FIFAConnectServiceBusV3Impl client;

    public MessagesImpl(Retrofit retrofit, FIFAConnectServiceBusV3Impl client) {
        this.service = (MessagesService)retrofit.create(MessagesService.class);
        this.client = client;
    }

    @Override
    public Object sendByRecipientAndActionAndProperties(String recipient, byte[] body) {
        return ((ServiceResponse)this.sendByRecipientAndActionAndPropertiesWithServiceResponseAsync(recipient, body).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> sendByRecipientAndActionAndPropertiesAsync(String recipient, byte[] body, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.sendByRecipientAndActionAndPropertiesWithServiceResponseAsync(recipient, body), serviceCallback);
    }

    @Override
    public Observable<Object> sendByRecipientAndActionAndPropertiesAsync(String recipient, byte[] body) {
        return this.sendByRecipientAndActionAndPropertiesWithServiceResponseAsync(recipient, body).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> sendByRecipientAndActionAndPropertiesWithServiceResponseAsync(String recipient, byte[] body) {
        if (recipient == null) {
            throw new IllegalArgumentException("Parameter recipient is required and cannot be null.");
        }
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        String xAction = null;
        String xProperties = null;
        return this.service.sendByRecipientAndActionAndProperties(recipient, xAction, xProperties, body).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = MessagesImpl.this.sendByRecipientAndActionAndPropertiesDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public Object sendByRecipientAndActionAndProperties(String recipient, byte[] body, String xAction, String xProperties) {
        return ((ServiceResponse)this.sendByRecipientAndActionAndPropertiesWithServiceResponseAsync(recipient, body, xAction, xProperties).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> sendByRecipientAndActionAndPropertiesAsync(String recipient, byte[] body, String xAction, String xProperties, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.sendByRecipientAndActionAndPropertiesWithServiceResponseAsync(recipient, body, xAction, xProperties), serviceCallback);
    }

    @Override
    public Observable<Object> sendByRecipientAndActionAndPropertiesAsync(String recipient, byte[] body, String xAction, String xProperties) {
        return this.sendByRecipientAndActionAndPropertiesWithServiceResponseAsync(recipient, body, xAction, xProperties).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> sendByRecipientAndActionAndPropertiesWithServiceResponseAsync(String recipient, byte[] body, String xAction, String xProperties) {
        if (recipient == null) {
            throw new IllegalArgumentException("Parameter recipient is required and cannot be null.");
        }
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        return this.service.sendByRecipientAndActionAndProperties(recipient, xAction, xProperties, body).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = MessagesImpl.this.sendByRecipientAndActionAndPropertiesDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Object> sendByRecipientAndActionAndPropertiesDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<Void>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(401, new TypeToken<Void>(){}.getType()).register(403, new TypeToken<DeliveryRestrictedResponseType>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).build(response);
    }

    @Override
    public Object receiveByRequest() {
        return ((ServiceResponseWithHeaders)this.receiveByRequestWithServiceResponseAsync().toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> receiveByRequestAsync(ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.receiveByRequestWithServiceResponseAsync(), serviceCallback);
    }

    @Override
    public Observable<Object> receiveByRequestAsync() {
        return this.receiveByRequestWithServiceResponseAsync().map((Func1)new Func1<ServiceResponseWithHeaders<Object, MessageReceiveByRequestHeaders>, Object>(){

            public Object call(ServiceResponseWithHeaders<Object, MessageReceiveByRequestHeaders> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Object, MessageReceiveByRequestHeaders>> receiveByRequestWithServiceResponseAsync() {
        Integer timeout = null;
        return this.service.receiveByRequest(timeout).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Object, MessageReceiveByRequestHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Object, MessageReceiveByRequestHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders<Object, MessageReceiveByRequestHeaders> clientResponse = MessagesImpl.this.receiveByRequestDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public Object receiveByRequest(Integer timeout) {
        return ((ServiceResponseWithHeaders)this.receiveByRequestWithServiceResponseAsync(timeout).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> receiveByRequestAsync(Integer timeout, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.receiveByRequestWithServiceResponseAsync(timeout), serviceCallback);
    }

    @Override
    public Observable<Object> receiveByRequestAsync(Integer timeout) {
        return this.receiveByRequestWithServiceResponseAsync(timeout).map((Func1)new Func1<ServiceResponseWithHeaders<Object, MessageReceiveByRequestHeaders>, Object>(){

            public Object call(ServiceResponseWithHeaders<Object, MessageReceiveByRequestHeaders> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Object, MessageReceiveByRequestHeaders>> receiveByRequestWithServiceResponseAsync(Integer timeout) {
        return this.service.receiveByRequest(timeout).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Object, MessageReceiveByRequestHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Object, MessageReceiveByRequestHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders<Object, MessageReceiveByRequestHeaders> clientResponse = MessagesImpl.this.receiveByRequestDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Object, MessageReceiveByRequestHeaders> receiveByRequestDelegate(Response<ResponseBody> response) throws RestException, IOException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<byte[]>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(401, new TypeToken<Void>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).buildWithHeaders(response, MessageReceiveByRequestHeaders.class);
    }

    @Override
    public Object peekLockByRequest() {
        return ((ServiceResponseWithHeaders)this.peekLockByRequestWithServiceResponseAsync().toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> peekLockByRequestAsync(ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.peekLockByRequestWithServiceResponseAsync(), serviceCallback);
    }

    @Override
    public Observable<Object> peekLockByRequestAsync() {
        return this.peekLockByRequestWithServiceResponseAsync().map((Func1)new Func1<ServiceResponseWithHeaders<Object, MessagePeekLockByRequestHeaders>, Object>(){

            public Object call(ServiceResponseWithHeaders<Object, MessagePeekLockByRequestHeaders> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Object, MessagePeekLockByRequestHeaders>> peekLockByRequestWithServiceResponseAsync() {
        Integer timeout = null;
        return this.service.peekLockByRequest(timeout).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Object, MessagePeekLockByRequestHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Object, MessagePeekLockByRequestHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders<Object, MessagePeekLockByRequestHeaders> clientResponse = MessagesImpl.this.peekLockByRequestDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    @Override
    public Object peekLockByRequest(Integer timeout) {
        return ((ServiceResponseWithHeaders)this.peekLockByRequestWithServiceResponseAsync(timeout).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> peekLockByRequestAsync(Integer timeout, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.peekLockByRequestWithServiceResponseAsync(timeout), serviceCallback);
    }

    @Override
    public Observable<Object> peekLockByRequestAsync(Integer timeout) {
        return this.peekLockByRequestWithServiceResponseAsync(timeout).map((Func1)new Func1<ServiceResponseWithHeaders<Object, MessagePeekLockByRequestHeaders>, Object>(){

            public Object call(ServiceResponseWithHeaders<Object, MessagePeekLockByRequestHeaders> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Object, MessagePeekLockByRequestHeaders>> peekLockByRequestWithServiceResponseAsync(Integer timeout) {
        return this.service.peekLockByRequest(timeout).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Object, MessagePeekLockByRequestHeaders>>>(){

            public Observable<ServiceResponseWithHeaders<Object, MessagePeekLockByRequestHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders<Object, MessagePeekLockByRequestHeaders> clientResponse = MessagesImpl.this.peekLockByRequestDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Object, MessagePeekLockByRequestHeaders> peekLockByRequestDelegate(Response<ResponseBody> response) throws RestException, IOException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<byte[]>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(401, new TypeToken<Void>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).register(410, new TypeToken<Void>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).buildWithHeaders(response, MessagePeekLockByRequestHeaders.class);
    }

    @Override
    public Object deleteByRequest(String messageId, String lockToken) {
        return ((ServiceResponse)this.deleteByRequestWithServiceResponseAsync(messageId, lockToken).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> deleteByRequestAsync(String messageId, String lockToken, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteByRequestWithServiceResponseAsync(messageId, lockToken), serviceCallback);
    }

    @Override
    public Observable<Object> deleteByRequestAsync(String messageId, String lockToken) {
        return this.deleteByRequestWithServiceResponseAsync(messageId, lockToken).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> deleteByRequestWithServiceResponseAsync(String messageId, String lockToken) {
        if (messageId == null) {
            throw new IllegalArgumentException("Parameter messageId is required and cannot be null.");
        }
        if (lockToken == null) {
            throw new IllegalArgumentException("Parameter lockToken is required and cannot be null.");
        }
        return this.service.deleteByRequest(messageId, lockToken).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = MessagesImpl.this.deleteByRequestDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Object> deleteByRequestDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(401, new TypeToken<Void>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).register(410, new TypeToken<Void>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).build(response);
    }

    @Override
    public Object unlockByRequest(String messageId, String lockToken) {
        return ((ServiceResponse)this.unlockByRequestWithServiceResponseAsync(messageId, lockToken).toBlocking().single()).body();
    }

    @Override
    public ServiceFuture<Object> unlockByRequestAsync(String messageId, String lockToken, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.unlockByRequestWithServiceResponseAsync(messageId, lockToken), serviceCallback);
    }

    @Override
    public Observable<Object> unlockByRequestAsync(String messageId, String lockToken) {
        return this.unlockByRequestWithServiceResponseAsync(messageId, lockToken).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> unlockByRequestWithServiceResponseAsync(String messageId, String lockToken) {
        if (messageId == null) {
            throw new IllegalArgumentException("Parameter messageId is required and cannot be null.");
        }
        if (lockToken == null) {
            throw new IllegalArgumentException("Parameter lockToken is required and cannot be null.");
        }
        return this.service.unlockByRequest(messageId, lockToken).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = MessagesImpl.this.unlockByRequestDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Object> unlockByRequestDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(401, new TypeToken<Void>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).register(410, new TypeToken<Void>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).build(response);
    }

    static interface MessagesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectservicebus.sdk.api.Messages sendByRecipientAndActionAndProperties"})
        @POST(value="api/v3/message/send")
        public Observable<Response<ResponseBody>> sendByRecipientAndActionAndProperties(@Query(value="recipient") String var1, @Header(value="X-Action") String var2, @Header(value="X-Properties") String var3, @Body byte[] var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectservicebus.sdk.api.Messages receiveByRequest"})
        @HTTP(path="api/v3/message/receive", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> receiveByRequest(@Query(value="timeout") Integer var1);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectservicebus.sdk.api.Messages peekLockByRequest"})
        @POST(value="api/v3/message/peeklock")
        public Observable<Response<ResponseBody>> peekLockByRequest(@Query(value="timeout") Integer var1);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectservicebus.sdk.api.Messages deleteByRequest"})
        @HTTP(path="api/v3/message/delete", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteByRequest(@Query(value="messageId") String var1, @Query(value="lockToken") String var2);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectservicebus.sdk.api.Messages unlockByRequest"})
        @PUT(value="api/v3/message/unlock")
        public Observable<Response<ResponseBody>> unlockByRequest(@Query(value="messageId") String var1, @Query(value="lockToken") String var2);
    }
}

