/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectservicebus.sdk.authentication;

import com.fifa.connectservicebus.sdk.authentication.AuthenticationResourceBuilder;
import com.fifa.connectservicebus.sdk.authentication.ClientCredentials;
import java.net.URI;

public class AuthenticationInformation {
    private String clientId;
    private String secretKey;
    private String tenant;
    private String resource;

    public AuthenticationInformation(AuthenticationResourceBuilder authenticationResourceBuilder, ClientCredentials clientCredentials, URI serviceUri, String tenant) {
        this(authenticationResourceBuilder, clientCredentials.getClientId(), clientCredentials.getSecretKey(), serviceUri, tenant);
    }

    private AuthenticationInformation(AuthenticationResourceBuilder resourceBuilder, String clientId, String secretKey, URI serviceUri, String tenant) {
        this.ensureNotEmpty(clientId, "clientId");
        this.ensureNotEmpty(secretKey, "secretKey");
        this.ensureNotEmpty(tenant, "tenant");
        this.ensureNotEmpty(serviceUri, "serviceUri");
        this.clientId = clientId;
        this.secretKey = secretKey;
        this.resource = resourceBuilder.buildResourceUri(serviceUri, tenant);
        this.tenant = tenant;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getResource() {
        return this.resource;
    }

    private void ensureNotEmpty(String input, String parameterName) {
        if (input == null || input.isEmpty()) {
            throw new IllegalArgumentException(String.format("Parameter %s can not be empty", parameterName));
        }
    }

    private void ensureNotEmpty(URI input, String parameterName) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Parameter %s can not be empty", parameterName));
        }
    }

    public String toString() {
        return "ClientId: " + this.clientId + ", Tenant: " + this.tenant + ", Resource: " + this.resource;
    }
}

