/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectservicebus.sdk.authentication;

import com.fifa.connectservicebus.sdk.authentication.AuthenticationService;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class AuthenticationInterceptor
implements Interceptor {
    private final AuthenticationService authenticationService;

    public AuthenticationInterceptor(AuthenticationService authenticationService) {
        if (authenticationService == null) {
            throw new IllegalArgumentException("Parameter authenticationService is required and can't be null");
        }
        this.authenticationService = authenticationService;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        IAuthenticationResult authenticationResult = this.authenticationService.acquireToken();
        Request request = chain.request();
        request = request.newBuilder().addHeader("Authorization", "Bearer " + authenticationResult.accessToken()).build();
        return chain.proceed(request);
    }
}

