/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectservicebus.sdk.authentication;

import com.fifa.connectservicebus.sdk.authentication.AuthenticationResourceBuilder;
import java.net.URI;
import java.util.HashMap;

public abstract class AuthenticationResourceBuilderBase
implements AuthenticationResourceBuilder {
    private HashMap<String, String> mapping;

    protected AuthenticationResourceBuilderBase(HashMap<String, String> mapping) {
        if (mapping == null) {
            throw new IllegalArgumentException("Mapping hash map cannot be null");
        }
        this.mapping = mapping;
    }

    @Override
    public String buildResourceUri(URI serviceUri, String tenant) {
        String serviceResourcePart = serviceUri.getHost();
        if (!this.mapping.containsKey(serviceResourcePart)) {
            throw new UnsupportedOperationException("Provided mapping hash map doesn't contain key: " + serviceResourcePart);
        }
        String mappedApplicationId = this.mapping.get(serviceResourcePart);
        return "https://" + tenant + "/" + mappedApplicationId;
    }
}

