/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectservicebus.sdk.authentication;

import com.fifa.connectservicebus.sdk.authentication.AuthenticationInformation;
import com.fifa.connectservicebus.sdk.authentication.AuthenticationService;
import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.aad.msal4j.IClientSecret;
import com.microsoft.aad.msal4j.IHttpClient;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;

public class AuthenticationServiceImpl
implements AuthenticationService {
    private final String authenticationEndpoint = "https://login.microsoftonline.com/";
    private final ConfidentialClientApplication app;
    private final ClientCredentialParameters clientCredentialParameters;

    public AuthenticationServiceImpl(AuthenticationInformation authenticationInformation, IHttpClient httpClient) {
        this(authenticationInformation, httpClient, null);
    }

    public AuthenticationServiceImpl(AuthenticationInformation authenticationInformation, IHttpClient httpClient, ExecutorService executorService) {
        if (authenticationInformation == null) {
            throw new IllegalArgumentException("Parameter authenticationInformation is required and can't be null");
        }
        this.app = this.buildApplication(authenticationInformation, httpClient, executorService);
        this.clientCredentialParameters = this.buildClientCredentials(authenticationInformation);
    }

    private ConfidentialClientApplication buildApplication(AuthenticationInformation authenticationInformation, IHttpClient httpClient, ExecutorService executorService) {
        IClientSecret credentials = ClientCredentialFactory.createFromSecret((String)authenticationInformation.getSecretKey());
        try {
            ConfidentialClientApplication.Builder builder = (ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)authenticationInformation.getClientId(), (IClientCredential)credentials).httpClient(httpClient)).authority(this.authenticationEndpoint + authenticationInformation.getTenant());
            if (executorService != null) {
                builder.executorService(executorService);
            }
            return builder.build();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid tenant", e);
        }
    }

    private ClientCredentialParameters buildClientCredentials(AuthenticationInformation authenticationInformation) {
        HashSet<CallSite> scopes = new HashSet<CallSite>();
        scopes.add((CallSite)((Object)(authenticationInformation.getResource() + "/.default")));
        return ClientCredentialParameters.builder(scopes).build();
    }

    @Override
    public IAuthenticationResult acquireToken() throws IOException {
        try {
            return (IAuthenticationResult)this.app.acquireToken(this.clientCredentialParameters).get();
        }
        catch (Exception e) {
            throw new IOException("Unable to retrieve access token", e);
        }
    }

    public String toString() {
        return "AuthenticationEndpoint: " + this.authenticationEndpoint;
    }
}

