/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectservicebus.sdk.encryption;

import com.fifa.connectservicebus.sdk.CryptographyException;
import com.fifa.connectservicebus.sdk.DecryptionException;
import com.fifa.connectservicebus.sdk.Message;
import com.fifa.connectservicebus.sdk.encryption.CertificateBasedCryptographyService;
import com.fifa.connectservicebus.sdk.encryption.CryptographyAlgorithm;
import com.fifa.connectservicebus.sdk.encryption.EncryptionResult;
import com.fifa.connectservicebus.sdk.encryption.PublicCertificateNotFoundException;
import com.fifa.connectservicebus.sdk.logging.Logger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CertificateBasedCryptographyAlgorithm
implements CryptographyAlgorithm {
    private final CertificateBasedCryptographyService cryptographyService;
    private final Logger logger;

    public CertificateBasedCryptographyAlgorithm(CertificateBasedCryptographyService cryptographyService, Logger logger) {
        this.cryptographyService = cryptographyService;
        this.logger = logger;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    public int getKeySize() {
        return 128;
    }

    public String getCipherMode() {
        return "CBC";
    }

    public String getPadding() {
        return "PKCS5PADDING";
    }

    public static String getEncryptionKey() {
        return "EncryptionKey";
    }

    public static String getEncryptionInitializationVectorKey() {
        return "EncryptionInitializationVector";
    }

    @Override
    public EncryptionResult encrypt(byte[] data, String queueIdentifier) throws CryptographyException, PublicCertificateNotFoundException {
        try {
            this.logger.debug("Started encryption of message content for queue '%s' using symmetric algorithm", queueIdentifier);
            Cipher cipher = Cipher.getInstance(String.format("AES/%s/%s", this.getCipherMode(), this.getPadding()));
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            kgen.init(this.getKeySize());
            SecretKey key = kgen.generateKey();
            SecureRandom randomSecureRandom = SecureRandom.getInstance("SHA1PRNG");
            byte[] iv = new byte[cipher.getBlockSize()];
            randomSecureRandom.nextBytes(iv);
            IvParameterSpec ivParams = new IvParameterSpec(iv);
            cipher.init(1, (Key)key, ivParams);
            this.logger.debug("Encrypting provided content using generated key and vector for queue '%s'", queueIdentifier);
            byte[] encrypted = cipher.doFinal(data);
            this.logger.debug("Message content encrypted successfully for queue '%s'", queueIdentifier);
            this.logger.debug("Encrypting generated key using asymmetric algorithm for queue '%s'", queueIdentifier);
            byte[] encryptedKey = this.cryptographyService.encrypt(key.getEncoded(), queueIdentifier);
            this.logger.debug("Key encrypted successfully queue '%s'", queueIdentifier);
            EncryptionResult result = new EncryptionResult();
            result.data = encrypted;
            result.properties.put(CertificateBasedCryptographyAlgorithm.getEncryptionKey(), Base64.getEncoder().encodeToString(encryptedKey));
            result.properties.put(CertificateBasedCryptographyAlgorithm.getEncryptionInitializationVectorKey(), Base64.getEncoder().encodeToString(iv));
            return result;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CryptographyException(String.format("Unable to encrypt content for queue %s", queueIdentifier), e);
        }
    }

    @Override
    public byte[] decrypt(Message message) throws CryptographyException {
        Map<String, String> properties = message.getProperties();
        if (!properties.containsKey(CertificateBasedCryptographyAlgorithm.getEncryptionKey())) {
            throw new DecryptionException(String.format("Parameter 'properties' does not contain %s encryption key", CertificateBasedCryptographyAlgorithm.getEncryptionKey()), message);
        }
        if (!properties.containsKey(CertificateBasedCryptographyAlgorithm.getEncryptionInitializationVectorKey())) {
            throw new DecryptionException(String.format("Parameter 'properties' does not contain %s initialization vector", CertificateBasedCryptographyAlgorithm.getEncryptionInitializationVectorKey()), message);
        }
        String encryptedKeyAsString = properties.get(CertificateBasedCryptographyAlgorithm.getEncryptionKey());
        String initializationVectorAsString = properties.get(CertificateBasedCryptographyAlgorithm.getEncryptionInitializationVectorKey());
        this.logger.debug("Staring decryption of message with provided parameters key: '%s', vector: '%s'", encryptedKeyAsString, initializationVectorAsString);
        byte[] encryptedKeyAsByteArray = Base64.getDecoder().decode(encryptedKeyAsString);
        IvParameterSpec iv = new IvParameterSpec(Base64.getDecoder().decode(initializationVectorAsString));
        try {
            this.logger.debug("Decrypting provided key.", new Object[0]);
            byte[] key = this.cryptographyService.decrypt(encryptedKeyAsByteArray, message);
            this.logger.debug("Key decrypted successfully.", new Object[0]);
            SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
            this.logger.debug("Decrypting message content using symmetric algorithm", new Object[0]);
            Cipher cipher = Cipher.getInstance(String.format("AES/%s/%s", this.getCipherMode(), this.getPadding()));
            cipher.init(2, (Key)skeySpec, iv);
            return cipher.doFinal(message.getContent());
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new DecryptionException(String.format("Unable to decrypt content for provided key: '%s' and vector: '%s'", encryptedKeyAsString, initializationVectorAsString), (Throwable)e, message);
        }
    }
}

