/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectservicebus.sdk.encryption;

import com.fifa.connectservicebus.sdk.CryptographyException;
import com.fifa.connectservicebus.sdk.FifaConnectServiceBusCertificateClient;
import com.fifa.connectservicebus.sdk.FifaConnectServiceBusException;
import com.fifa.connectservicebus.sdk.encryption.PublicCertificateNotFoundException;
import com.fifa.connectservicebus.sdk.encryption.PublicCertificateProvider;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Duration;

public class MemoryBasedPublicCertificateProvider
implements PublicCertificateProvider {
    private final FifaConnectServiceBusCertificateClient certificateClient;
    private final Cache<String, X509Certificate> cache;

    public MemoryBasedPublicCertificateProvider(FifaConnectServiceBusCertificateClient certificateClient, Duration expirationTimeSpan) {
        if (certificateClient == null) {
            throw new IllegalArgumentException("certificateClient cannot be null");
        }
        this.certificateClient = certificateClient;
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(expirationTimeSpan).build();
    }

    @Override
    public X509Certificate get(String queueIdentifier) throws PublicCertificateNotFoundException, CryptographyException {
        X509Certificate certificate = (X509Certificate)this.cache.getIfPresent((Object)queueIdentifier);
        if (certificate == null) {
            certificate = this.reload(queueIdentifier);
        }
        return certificate;
    }

    private X509Certificate reload(String queueIdentifier) throws PublicCertificateNotFoundException, CryptographyException {
        X509Certificate certificate;
        byte[] certificateRawData = new byte[]{};
        try {
            certificateRawData = this.certificateClient.downloadCertificate(queueIdentifier);
        }
        catch (FifaConnectServiceBusException e) {
            String message = "Queue '" + queueIdentifier + "' has not uploaded their public key.";
            throw new PublicCertificateNotFoundException(message, e);
        }
        ByteArrayInputStream certificateStream = new ByteArrayInputStream(certificateRawData);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            certificate = (X509Certificate)cf.generateCertificate(certificateStream);
        }
        catch (CertificateException e) {
            throw new CryptographyException(String.format("Unable to load certificate content as X509Certificate for queue '%s'", queueIdentifier), e);
        }
        this.cache.put((Object)queueIdentifier, (Object)certificate);
        return certificate;
    }
}

