/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectservicebus.sdk.encryption;

import com.fifa.connectservicebus.sdk.CryptographyException;
import com.fifa.connectservicebus.sdk.DecryptionException;
import com.fifa.connectservicebus.sdk.Message;
import com.fifa.connectservicebus.sdk.encryption.CryptographyAlgorithm;
import com.fifa.connectservicebus.sdk.encryption.EncryptionResult;
import com.fifa.connectservicebus.sdk.encryption.MessageCryptographyService;
import com.fifa.connectservicebus.sdk.encryption.PublicCertificateNotFoundException;
import com.fifa.connectservicebus.sdk.enhancements.IntegerExtensions;
import com.fifa.connectservicebus.sdk.logging.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class MessageCryptographyServiceImpl
implements MessageCryptographyService {
    private final List<CryptographyAlgorithm> algorithms;
    private final Logger logger;
    public static String encryptionVersionKey = "EncryptionVersion";

    public MessageCryptographyServiceImpl(List<CryptographyAlgorithm> algorithms, Logger logger) {
        if (algorithms == null || algorithms.size() == 0) {
            throw new IllegalArgumentException("Parameter 'algorithms' need to have at least one item");
        }
        if (this.getUniqueAlgorithmsVersionsCount(algorithms) != algorithms.size()) {
            throw new IllegalArgumentException("Collection of 'algorithms' cannot contain items with the same version need to have at least one item");
        }
        if (logger == null) {
            throw new IllegalArgumentException("Parameter 'logger' can not be null");
        }
        this.logger = logger;
        this.algorithms = algorithms;
        Collections.sort(this.algorithms, new Comparator<CryptographyAlgorithm>(){

            @Override
            public int compare(CryptographyAlgorithm o1, CryptographyAlgorithm o2) {
                return Integer.compare(o1.getVersion(), o2.getVersion()) * -1;
            }
        });
    }

    @Override
    public EncryptionResult encrypt(byte[] data, String queueIdentifier) throws CryptographyException, PublicCertificateNotFoundException {
        this.logger.debug("Starting selection of algorithm used for encryption for '%s'", queueIdentifier);
        CryptographyAlgorithm selectedAlgorithm = this.algorithms.get(0);
        this.logger.debug("Encrypting content for '%s' using selected algorithm version '%d'", queueIdentifier, selectedAlgorithm.getVersion());
        EncryptionResult result = selectedAlgorithm.encrypt(data, queueIdentifier);
        result.properties.put(encryptionVersionKey, Integer.toString(selectedAlgorithm.getVersion()));
        this.logger.debug("Encrypting was done successfully for '%s' using selected algorithm version '%d'", queueIdentifier, selectedAlgorithm.getVersion());
        return result;
    }

    @Override
    public byte[] decrypt(Message message) throws CryptographyException {
        Map<String, String> properties = message.getProperties();
        if (!properties.containsKey(encryptionVersionKey)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = encryptionVersionKey;
            throw new DecryptionException(String.format("There is no '%s' parameter provided in 'properties' collection.", objectArray), message);
        }
        Integer version = IntegerExtensions.tryParse(properties.get(encryptionVersionKey));
        if (version == null) {
            Object[] objectArray = new Object[1];
            objectArray[0] = properties.get(encryptionVersionKey);
            throw new DecryptionException(String.format("Unable to parse algorithm version from '%s'", objectArray), message);
        }
        this.logger.debug("Looking for algorithm for decryption with version '%s'", version.toString());
        CryptographyAlgorithm algorithm = this.getCryptographyAlgorithm(version);
        if (algorithm == null) {
            throw new DecryptionException(String.format("There is no cryptography algorithm that can support '%s' version.", version), message);
        }
        this.logger.debug("Decrypting content using algorithm for version '%s'", version.toString());
        return algorithm.decrypt(message);
    }

    private CryptographyAlgorithm getCryptographyAlgorithm(int version) {
        for (CryptographyAlgorithm algorithm : this.algorithms) {
            if (algorithm.getVersion() != version) continue;
            return algorithm;
        }
        return null;
    }

    private int getUniqueAlgorithmsVersionsCount(List<CryptographyAlgorithm> algorithms) {
        ArrayList<String> values = new ArrayList<String>();
        for (CryptographyAlgorithm algorithm : algorithms) {
            String version = Integer.toString(algorithm.getVersion());
            if (values.contains(version)) continue;
            values.add(version);
        }
        return values.size();
    }
}

