/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectservicebus.sdk.encryption;

import com.fifa.connectservicebus.sdk.encryption.PrivateKeyStorage;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

public class PrivateKeyMemoryStorage
implements PrivateKeyStorage {
    private PrivateKey privateKey;
    private LinkedList<PrivateKey> oldPrivateKeys;

    public PrivateKeyMemoryStorage(PrivateKey privateKey) {
        if (privateKey == null) {
            throw new IllegalArgumentException("privateKey cannot be null");
        }
        this.oldPrivateKeys = new LinkedList();
        this.privateKey = privateKey;
    }

    @Override
    public PrivateKey getLatestKey() {
        return this.privateKey;
    }

    @Override
    public Collection<PrivateKey> getPreviousKeys() {
        ArrayList<PrivateKey> result = new ArrayList<PrivateKey>();
        boolean isFirst = true;
        for (PrivateKey node : this.oldPrivateKeys) {
            if (isFirst) {
                isFirst = false;
                continue;
            }
            result.add(node);
        }
        return result;
    }

    public void addNewKey(PrivateKey privateKey) {
        if (privateKey == null) {
            throw new IllegalArgumentException("privateKey cannot be null");
        }
        this.oldPrivateKeys.addFirst(this.privateKey);
        this.privateKey = privateKey;
    }
}

