/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectservicebus.sdk.encryption;

import com.fifa.connectservicebus.sdk.CryptographyException;
import com.fifa.connectservicebus.sdk.DecryptionException;
import com.fifa.connectservicebus.sdk.Message;
import com.fifa.connectservicebus.sdk.encryption.CertificateBasedCryptographyService;
import com.fifa.connectservicebus.sdk.encryption.PrivateKeyStorage;
import com.fifa.connectservicebus.sdk.encryption.PublicCertificateNotFoundException;
import com.fifa.connectservicebus.sdk.encryption.PublicCertificateProvider;
import com.fifa.connectservicebus.sdk.logging.Logger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class RSACryptographyService
implements CertificateBasedCryptographyService {
    private final PublicCertificateProvider publicCertificateProvider;
    private final PrivateKeyStorage privateKeyStorage;
    private final Logger logger;

    public RSACryptographyService(PublicCertificateProvider publicCertificateProvider, PrivateKeyStorage privateKeyStorage, Logger logger) {
        if (publicCertificateProvider == null) {
            throw new IllegalArgumentException("Parameter 'publicCertificateProvider' can not be null");
        }
        if (privateKeyStorage == null) {
            throw new IllegalArgumentException("Parameter 'privateKeyStorage' can not be null");
        }
        if (logger == null) {
            throw new IllegalArgumentException("Parameter 'logger' can not be null");
        }
        this.publicCertificateProvider = publicCertificateProvider;
        this.privateKeyStorage = privateKeyStorage;
        this.logger = logger;
    }

    @Override
    public byte[] encrypt(byte[] data, String queueIdentfier) throws CryptographyException, PublicCertificateNotFoundException {
        try {
            X509Certificate certificate = this.publicCertificateProvider.get(queueIdentfier);
            Cipher rsa = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            rsa.init(1, certificate);
            return rsa.doFinal(data);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CryptographyException(String.format("Unable to encrypt content using RSA algorithm for queue : '%s'", queueIdentfier), e);
        }
    }

    @Override
    public byte[] decrypt(byte[] data, Message message) throws CryptographyException {
        PrivateKey currentKey = this.privateKeyStorage.getLatestKey();
        byte[] decryptedContent = this.tryDecrypt(currentKey, data);
        if (decryptedContent != null) {
            return decryptedContent;
        }
        Collection<PrivateKey> previousPrivateKeys = this.privateKeyStorage.getPreviousKeys();
        for (PrivateKey key : previousPrivateKeys) {
            decryptedContent = this.tryDecrypt(key, data);
            if (decryptedContent == null) continue;
            return decryptedContent;
        }
        throw new DecryptionException("Could not decrypt the data with any of the private keys.\"", message);
    }

    private byte[] tryDecrypt(PrivateKey key, byte[] data) {
        try {
            Cipher rsa = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            rsa.init(2, key);
            return rsa.doFinal(data);
        }
        catch (Exception ex) {
            return null;
        }
    }
}

