/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectservicebus.sdk.errorhandling;

import com.fifa.connectservicebus.sdk.FifaConnectServiceBusException;
import com.fifa.connectservicebus.sdk.InvalidClientDataException;
import com.fifa.connectservicebus.sdk.api.models.BadRequestResponseType;
import com.fifa.connectservicebus.sdk.api.models.DetailsItemType;
import com.fifa.connectservicebus.sdk.errorhandling.ErrorResponseHandler;
import com.google.common.base.Joiner;
import com.microsoft.rest.ServiceResponse;
import java.util.ArrayList;
import java.util.List;

public class BadRequestHandler
implements ErrorResponseHandler {
    @Override
    public void handle(ServiceResponse<Object> serviceResponse) throws FifaConnectServiceBusException {
        if (serviceResponse.response().code() != 400) {
            return;
        }
        Object responseBody = serviceResponse.body();
        if (responseBody instanceof BadRequestResponseType) {
            BadRequestResponseType badRequestResponse = (BadRequestResponseType)responseBody;
            String message = BadRequestHandler.formatMessage(badRequestResponse);
            throw new InvalidClientDataException(message, badRequestResponse, serviceResponse);
        }
    }

    private static String formatMessage(BadRequestResponseType body) {
        String message = "The service responded with status code 400. " + body.message();
        List<DetailsItemType> messageDetails = body.details();
        if (messageDetails == null || messageDetails.isEmpty()) {
            return message;
        }
        ArrayList<String> details = new ArrayList<String>(messageDetails.size());
        for (DetailsItemType item : messageDetails) {
            details.add(String.format("%s: %s", item.key(), item.value()));
        }
        message = message + ": { " + Joiner.on((String)"; ").join(details) + " }";
        return message;
    }
}

