/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectservicebus.sdk.errorhandling;

import com.fifa.connectservicebus.sdk.FifaConnectServiceBusException;
import com.fifa.connectservicebus.sdk.TooManyRequestsException;
import com.fifa.connectservicebus.sdk.api.models.TooManyRequestsResponseType;
import com.fifa.connectservicebus.sdk.errorhandling.ErrorResponseHandler;
import com.microsoft.rest.ServiceResponse;

public class TooManyRequestsHandler
implements ErrorResponseHandler {
    @Override
    public void handle(ServiceResponse<Object> serviceResponse) throws FifaConnectServiceBusException {
        TooManyRequestsResponseType response = null;
        if (serviceResponse.body() instanceof TooManyRequestsResponseType) {
            response = (TooManyRequestsResponseType)serviceResponse.body();
        }
        String retryAfterHeaderValue = serviceResponse.response().headers().get("retry-after");
        Integer retryAfter = this.parseIntOrNull(retryAfterHeaderValue);
        if (response != null && response.statusCode() == 429 && retryAfter != null) {
            throw new TooManyRequestsException(response.message(), retryAfter, serviceResponse);
        }
    }

    private Integer parseIntOrNull(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

