/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectservicebus.sdk.logging;

import com.fifa.connectservicebus.sdk.logging.Logger;
import org.apache.commons.lang3.exception.ExceptionUtils;

public abstract class BaseLogger
implements Logger {
    @Override
    public void debug(String format, Object ... args) {
        this.debug(this.formatMessage(format, args));
    }

    @Override
    public void debug(Exception exception, String format, Object ... args) {
        this.debug(this.formatMessage(format, args) + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)exception));
    }

    @Override
    public void error(String format, Object ... args) {
        this.error(this.formatMessage(format, args));
    }

    @Override
    public void error(Exception exception, String format, Object ... args) {
        this.error(this.formatMessage(format, args) + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)exception));
    }

    protected abstract void debug(String var1);

    protected abstract void error(String var1);

    protected String formatMessage(String format, Object ... args) {
        try {
            return String.format(format, args);
        }
        catch (Exception e) {
            Object message = format;
            for (Object arg : args) {
                if (arg == null) continue;
                message = (String)message + " " + arg.toString();
            }
            return message;
        }
    }
}

