/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk;

import com.fifa.connectid.sdk.CacheCleanJob;
import com.fifa.connectid.sdk.CancellationToken;
import com.fifa.connectid.sdk.CancellationTokenSource;
import com.fifa.connectid.sdk.ExtensibleBackgroundListener;
import com.fifa.connectid.sdk.GenericMessageReceivedEvent;
import com.fifa.connectid.sdk.NullCancellationToken;
import com.fifa.connectid.sdk.PersonDetailsReceivedEvent;
import com.fifa.connectid.sdk.PersonDetailsRequestReceivedEvent;
import com.fifa.connectid.sdk.ServiceBusExceptionEvent;
import com.fifa.connectid.sdk.messageHandlers.GenericMessageHandler;
import com.fifa.connectid.sdk.messageHandlers.MessageHandler;
import com.fifa.connectid.sdk.messageHandlers.PersonDetailsHandler;
import com.fifa.connectid.sdk.messageHandlers.PersonDetailsRequestHandler;
import com.fifa.connectservicebus.sdk.FifaConnectServiceBusClient;
import com.fifa.connectservicebus.sdk.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class BackgroundListener {
    private final ExtensibleBackgroundListener extensibleBackgroundListener;
    private final Logger logger;
    private final CacheCleanJob cleanJob;
    public PersonDetailsRequestReceivedEvent personDetailsRequestReceivedEvent = new PersonDetailsRequestReceivedEvent();
    public PersonDetailsReceivedEvent personDetailsReceivedEvent = new PersonDetailsReceivedEvent();
    public GenericMessageReceivedEvent genericMessageReceivedEvent = new GenericMessageReceivedEvent();
    public ServiceBusExceptionEvent serviceBusExceptionEvent = new ServiceBusExceptionEvent();

    public BackgroundListener(FifaConnectServiceBusClient client, CacheCleanJob cleanJob, Logger logger) {
        this(client, cleanJob, logger, new ArrayList<MessageHandler>());
    }

    public BackgroundListener(FifaConnectServiceBusClient client, CacheCleanJob cleanJob, Logger logger, Collection<MessageHandler> customMessageHandlers) {
        this.cleanJob = cleanJob;
        this.logger = logger;
        this.extensibleBackgroundListener = this.createListener(client, customMessageHandlers);
    }

    private ExtensibleBackgroundListener createListener(FifaConnectServiceBusClient client, Collection<MessageHandler> customMessageHandlers) {
        ServiceBusExceptionEvent personDetailsRequestFailed = new ServiceBusExceptionEvent();
        PersonDetailsRequestHandler personDetailsRequestHandler = new PersonDetailsRequestHandler(this.personDetailsRequestReceivedEvent::raise, personDetailsRequestFailed::raise);
        ArrayList<MessageHandler> messageHandlers = new ArrayList<MessageHandler>();
        messageHandlers.add(personDetailsRequestHandler);
        messageHandlers.add(new PersonDetailsHandler(this.personDetailsReceivedEvent::raise));
        ArrayList customHandlers = customMessageHandlers != null ? customMessageHandlers : new ArrayList();
        messageHandlers.addAll(customHandlers);
        messageHandlers.add(new GenericMessageHandler(this.genericMessageReceivedEvent::raise));
        ExtensibleBackgroundListener listener = new ExtensibleBackgroundListener(client, this.logger, messageHandlers);
        listener.serviceBusExceptionEvent.addHandler(this.serviceBusExceptionEvent::raise);
        personDetailsRequestFailed.addHandler(target -> listener.letClientHandleServiceBusException((Exception)target, target.getMessage()));
        return listener;
    }

    public void run() {
        this.runInternal(new NullCancellationToken());
    }

    public void run(CancellationToken token) {
        this.runInternal(token);
    }

    public void runInBackgroundThread(CancellationToken token) {
        new Thread(() -> this.runInternal(token)).start();
    }

    public void runInBackgroundThread() {
        this.runInBackgroundThread(new NullCancellationToken());
    }

    public void runWithTimeout(int milliseconds) {
        CancellationTokenSource source2 = new CancellationTokenSource();
        source2.cancelAfter(milliseconds);
        this.runWithTimeout(milliseconds, source2.getToken());
    }

    public boolean runWithTimeout(int milliseconds, CancellationToken token) {
        boolean completedWithoutExceptions;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Void> future = executor.submit(() -> {
            this.runInternal(token);
            return null;
        });
        try {
            future.get(milliseconds, TimeUnit.MILLISECONDS);
            completedWithoutExceptions = true;
        }
        catch (TimeoutException e) {
            future.cancel(true);
            completedWithoutExceptions = false;
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            completedWithoutExceptions = false;
        }
        executor.shutdownNow();
        return completedWithoutExceptions;
    }

    private void runInternal(CancellationToken token) {
        if (this.cleanJob != null) {
            this.cleanJob.run(token);
        }
        this.extensibleBackgroundListener.run(token);
    }

    public int getExceptionCounterLimit() {
        return this.extensibleBackgroundListener.getExceptionCounterLimit();
    }

    public void setExceptionCounterLimit(int exceptionCounterLimit) {
        this.extensibleBackgroundListener.setExceptionCounterLimit(exceptionCounterLimit);
    }

    public long getExceptionSleepTimeMilliseconds() {
        return this.extensibleBackgroundListener.getExceptionSleepTimeMilliseconds();
    }

    public void setExceptionSleepTimeMilliseconds(long exceptionSleepTimeMilliseconds) {
        this.extensibleBackgroundListener.setExceptionSleepTimeMilliseconds(exceptionSleepTimeMilliseconds);
    }
}

