/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk;

import com.fifa.connectid.sdk.CorrelationIdBasedItemProvider;
import com.fifa.connectid.sdk.ResponseAwaiter;
import java.time.Duration;

public class CachePollingResponseAwaiter<Response>
implements ResponseAwaiter<Response> {
    private final CorrelationIdBasedItemProvider<Response> cache;
    private final long pollingIntervalMilliseconds;

    public CachePollingResponseAwaiter(CorrelationIdBasedItemProvider<Response> cache, long pollingIntervalMilliseconds) {
        this.cache = cache;
        this.pollingIntervalMilliseconds = pollingIntervalMilliseconds;
    }

    @Override
    public Response waitForResponse(String correlationId, Duration timeout2) throws Exception {
        Response response;
        long endTime = System.currentTimeMillis() + timeout2.toMillis();
        do {
            if (System.currentTimeMillis() > endTime) {
                return null;
            }
            try {
                Thread.sleep(this.pollingIntervalMilliseconds);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while ((response = this.cache.getByCorrelationId(correlationId)) == null);
        return response;
    }
}

