/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk;

import com.fifa.connectid.sdk.EventHandler;
import com.fifa.connectid.sdk.PersonDetailsProvider;
import com.fifa.connectid.sdk.PersonDetailsRequest;
import com.fifa.connectid.sdk.core.SdkVersionHelper;
import com.fifa.connectservicebus.sdk.FifaConnectServiceBusClient;
import java.util.HashMap;

public class DefaultPersonDetailsRequestReceivedHandler
implements EventHandler<PersonDetailsRequest> {
    private final FifaConnectServiceBusClient client;
    private PersonDetailsProvider provider;

    public DefaultPersonDetailsRequestReceivedHandler(FifaConnectServiceBusClient client, PersonDetailsProvider provider) {
        this.client = client;
        this.provider = provider;
    }

    public FifaConnectServiceBusClient getClient() {
        return this.client;
    }

    public PersonDetailsProvider getProvider() {
        return this.provider;
    }

    @Override
    public void handle(PersonDetailsRequest personDetailsRequest) throws Exception {
        String personDetails = this.provider.getPersonDetails(personDetailsRequest);
        String recipient = personDetailsRequest.getReplyTo();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("correlationId", personDetailsRequest.getCorrelationId());
        properties.put("version", SdkVersionHelper.GetTechnologyWithVersion());
        byte[] content = personDetails != null ? personDetails.getBytes() : null;
        this.client.send(recipient, content, "person-details", properties);
    }
}

