/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk;

import com.fifa.connectid.sdk.CancellationToken;
import com.fifa.connectid.sdk.ServiceBusExceptionEvent;
import com.fifa.connectid.sdk.messageHandlers.MessageHandler;
import com.fifa.connectid.sdk.util.CorrelationIdFormatter;
import com.fifa.connectid.sdk.util.PrefixedLogger;
import com.fifa.connectservicebus.sdk.CryptographyException;
import com.fifa.connectservicebus.sdk.DecryptionException;
import com.fifa.connectservicebus.sdk.FifaConnectServiceBusClient;
import com.fifa.connectservicebus.sdk.Message;
import com.fifa.connectservicebus.sdk.logging.Logger;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

class ExtensibleBackgroundListener {
    private final FifaConnectServiceBusClient client;
    private final Logger logger;
    private final List<MessageHandler> messageHandlers;
    private int exceptionCounterLimit = 10;
    private long exceptionSleepTimeMilliseconds = 10000L;
    public ServiceBusExceptionEvent serviceBusExceptionEvent = new ServiceBusExceptionEvent();

    public ExtensibleBackgroundListener(FifaConnectServiceBusClient client, Logger logger, List<MessageHandler> messageHandlers) {
        this.client = client;
        this.logger = new PrefixedLogger(logger, "[LID: " + UUID.randomUUID() + "] ");
        this.messageHandlers = messageHandlers;
    }

    public void run(CancellationToken token) {
        this.LogRegisteredHandlers();
        int exceptionCounter = 0;
        while (true) {
            if (token.getIsCancellationRequested()) break;
            try {
                Message lockedMessage = this.client.peekLock(60);
                if (lockedMessage == null) continue;
                this.logger.debug(ExtensibleBackgroundListener.GetFormattedCorrelationId(lockedMessage) + "Received and locked a message: " + lockedMessage, new Object[0]);
                try {
                    String action = lockedMessage.getAction().toLowerCase();
                    MessageHandler messageHandler = this.SelectHandlerFor(action);
                    if (messageHandler == null) {
                        throw new Exception("Message with unrecognized action type '\" + action + \"' was not processed, because no generic message handler was provided.");
                    }
                    this.logger.debug("Processing message using %s", new Object[]{messageHandler});
                    messageHandler.handle(action, lockedMessage);
                    this.logger.debug("The message with id " + lockedMessage.getId() + " was processed properly. It will be deleted now.", new Object[0]);
                }
                catch (Exception e) {
                    this.logger.error(e, "The message with id " + lockedMessage.getId() + " was NOT processed properly. It will be unlocked now.", new Object[0]);
                    this.client.unlock(lockedMessage.getId(), lockedMessage.getLockToken());
                    continue;
                }
                this.client.delete(lockedMessage.getId(), lockedMessage.getLockToken());
                exceptionCounter = 0;
            }
            catch (DecryptionException e) {
                this.logger.error(ExtensibleBackgroundListener.GetFormattedCorrelationId(e.getServiceBusMessage()) + "Failed to decrypt content of received and locked a message: " + e.getServiceBusMessage(), new Object[0]);
                this.letClientHandleServiceBusException((Exception)((Object)e), e.getMessage());
            }
            catch (CryptographyException e) {
                this.letClientHandleServiceBusException((Exception)((Object)e), e.getMessage());
            }
            catch (Exception e) {
                this.letClientHandleServiceBusException(e, "Message processing resulted with an exception");
                if (exceptionCounter > this.getExceptionCounterLimit()) {
                    try {
                        Thread.sleep(this.getExceptionSleepTimeMilliseconds());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    exceptionCounter = 0;
                    continue;
                }
                ++exceptionCounter;
            }
        }
        this.logger.debug("Terminating...", new Object[0]);
    }

    void letClientHandleServiceBusException(Exception exception, String context) {
        try {
            this.logger.debug("Letting the client to handle a Service Bus exception.", new Object[0]);
            this.logger.error(exception, context, new Object[0]);
            this.serviceBusExceptionEvent.raise(exception);
        }
        catch (Exception e) {
            this.logger.error(e, "Exception was not properly handled by the client - an exception was thrown.", new Object[0]);
        }
    }

    public int getExceptionCounterLimit() {
        return this.exceptionCounterLimit;
    }

    public void setExceptionCounterLimit(int exceptionCounterLimit) {
        this.exceptionCounterLimit = exceptionCounterLimit;
    }

    public long getExceptionSleepTimeMilliseconds() {
        return this.exceptionSleepTimeMilliseconds;
    }

    public void setExceptionSleepTimeMilliseconds(long exceptionSleepTimeMilliseconds) {
        this.exceptionSleepTimeMilliseconds = exceptionSleepTimeMilliseconds;
    }

    private MessageHandler SelectHandlerFor(String action) {
        return this.messageHandlers.stream().filter(handler -> handler.canHandle(action)).findFirst().orElse(null);
    }

    private void LogRegisteredHandlers() {
        String handlers = this.messageHandlers.stream().map(Object::toString).collect(Collectors.joining(", "));
        this.logger.debug("Starting with the following handlers: " + handlers, new Object[0]);
    }

    private static String GetFormattedCorrelationId(Message message) {
        return CorrelationIdFormatter.format(message.getProperty("correlationId"));
    }
}

