/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk;

import com.fifa.connectid.sdk.core.HashedPersonProcessor;
import com.fifa.connectid.sdk.core.HashedPersonType;
import com.fifa.connectservicebus.sdk.StringUtils;
import com.google.common.io.BaseEncoding;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashedPersonTypeHashingProcessorImpl
implements HashedPersonProcessor {
    @Override
    public HashedPersonType process(HashedPersonType hashedPersonType) {
        String hash;
        if (hashedPersonType == null) {
            return null;
        }
        if (StringUtils.isNullOrEmpty((String)hashedPersonType.getLocalId())) {
            return hashedPersonType;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            byte[] bytes = md.digest(hashedPersonType.getLocalId().getBytes(StandardCharsets.UTF_8));
            hash = this.encodeHex(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        HashedPersonType processedHashedType = new HashedPersonType();
        processedHashedType.setNameHashes(hashedPersonType.getNameHashes());
        processedHashedType.setPerson(hashedPersonType.getPerson());
        processedHashedType.setLocalId(hash);
        return processedHashedType;
    }

    private String encodeHex(byte[] bytes) {
        return BaseEncoding.base16().lowerCase().encode(bytes);
    }
}

