/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk;

import com.fifa.connectid.sdk.core.SdkVersionHelper;
import com.fifa.connectid.sdk.util.CorrelationIdFormatter;
import com.fifa.connectservicebus.sdk.FifaConnectServiceBusClient;
import com.fifa.connectservicebus.sdk.FifaConnectServiceBusException;
import com.fifa.connectservicebus.sdk.logging.Logger;
import java.util.HashMap;

class PersonDetailsMessageExchanger {
    private final FifaConnectServiceBusClient serviceBusClient;
    private final Logger logger;

    public PersonDetailsMessageExchanger(FifaConnectServiceBusClient serviceBusClient, Logger logger) {
        this.serviceBusClient = serviceBusClient;
        this.logger = logger;
    }

    public void sendRequestForPersonDetails(String uniqueFifaId, String recipient, String correlationId) throws FifaConnectServiceBusException {
        this.logger.debug(CorrelationIdFormatter.format(correlationId) + "Sending a request for details of '%s' to organisation '%s'.", new Object[]{uniqueFifaId, recipient});
        this.createAndSendPersonDetailsMessage(uniqueFifaId, recipient, correlationId);
        this.logger.debug(CorrelationIdFormatter.format(correlationId) + "Request for details of `%s` was sent to organisation '%s'.", new Object[]{uniqueFifaId, recipient});
    }

    private void createAndSendPersonDetailsMessage(String uniqueFifaId, String recipient, String correlationId) throws FifaConnectServiceBusException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("uniqueFifaId", uniqueFifaId);
        properties.put("correlationId", correlationId);
        properties.put("version", SdkVersionHelper.GetTechnologyWithVersion());
        String message = " ";
        this.serviceBusClient.send(recipient, " ".getBytes(), "person-details-request", properties);
    }
}

