/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk;

import com.fifa.connectid.sdk.ValidationException;
import com.fifa.connectid.sdk.core.SdkVersionHelper;
import com.fifa.connectid.sdk.core.UnauthorizedException;
import com.fifa.connectid.sdk.core.XmlSerializationException;
import com.fifa.connectid.sdk.core.apimodelvalidation.ApiModelValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.SystemIdValidator;
import com.fifa.connectid.sdk.core.xmlserializer.PersonLocalXmlSerializer;
import com.fifa.connectid.sdk.core.xmlserializer.PersonLocalXmlSerializerImpl;
import com.fifa.connectservicebus.sdk.FifaConnectServiceBusClient;
import com.fifa.connectservicebus.sdk.FifaConnectServiceBusException;
import com.fifa.fc.PersonLocal;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.xml.sax.SAXException;

public class PersonLocalSender {
    private final FifaConnectServiceBusClient serviceBusClient;
    private final PersonLocalXmlSerializer personLocalXmlSerializer;

    public PersonLocalSender(FifaConnectServiceBusClient serviceBusClient) {
        this.serviceBusClient = serviceBusClient;
        this.personLocalXmlSerializer = new PersonLocalXmlSerializerImpl();
    }

    public void send(final PersonLocal personLocal, String recipient, String messageType) throws ValidationException, UnauthorizedException, FifaConnectServiceBusException, JAXBException, IOException, XmlSerializationException, SAXException {
        new SystemIdValidator().validate(recipient, "recipient");
        ApiModelValidator.cannotBeNullOrWhitespace(messageType, "messageType");
        String xml = this.personLocalXmlSerializer.serialize(personLocal);
        byte[] content = xml.getBytes();
        HashMap<String, String> properties = new HashMap<String, String>(){
            {
                this.put("uniqueFifaId", personLocal.getPersonFIFAId());
                this.put("version", SdkVersionHelper.GetTechnologyWithVersion());
            }
        };
        this.serviceBusClient.send(recipient, content, messageType, (Map)properties);
    }
}

