/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core;

import com.fifa.connectservicebus.sdk.ConnectServiceBusEnvironment;
import java.text.MessageFormat;

public class ConnectIdEnvironment {
    public String HashingServiceUrl;
    public String IdDirectoryUrl;
    public String Tenant;
    public ConnectServiceBusEnvironment ServiceBusEnvironment;
    static final String HashingApiPath = "hashing";
    static final String IdDirectoryApiPath = "iddirectory";
    private static final String defaultTenant = "fifaconnect.onmicrosoft.com";
    public static ConnectIdEnvironment integration = ConnectIdEnvironment.create("int");
    public static ConnectIdEnvironment hotfix = ConnectIdEnvironment.create("hfix");
    public static ConnectIdEnvironment beta = ConnectIdEnvironment.create("beta");
    public static ConnectIdEnvironment preProduction = ConnectIdEnvironment.create("prep");
    public static ConnectIdEnvironment production = ConnectIdEnvironment.create("prod");

    public ConnectIdEnvironment(String tenant, String hashingServiceUrl, String idDirectoryUrl, ConnectServiceBusEnvironment serviceBusEnvironment) {
        this.Tenant = tenant;
        this.HashingServiceUrl = hashingServiceUrl;
        this.IdDirectoryUrl = idDirectoryUrl;
        this.ServiceBusEnvironment = serviceBusEnvironment;
    }

    public static ConnectIdEnvironment create(String environmentCode) {
        MessageFormat urlFormat = new MessageFormat("https://fci-apim-{0}.azure-api.net/{1}/");
        return new ConnectIdEnvironment(defaultTenant, urlFormat.format(new Object[]{environmentCode, HashingApiPath}), urlFormat.format(new Object[]{environmentCode, IdDirectoryApiPath}), ConnectIdEnvironment.createServiceBusEnvironment(environmentCode));
    }

    private static ConnectServiceBusEnvironment createServiceBusEnvironment(String environmentCode) {
        switch (environmentCode) {
            case "prod": {
                return ConnectServiceBusEnvironment.production;
            }
            case "prep": {
                return ConnectServiceBusEnvironment.preProduction;
            }
        }
        return ConnectServiceBusEnvironment.create((String)environmentCode);
    }

    public String toString() {
        return "HashingServiceUrl: " + this.HashingServiceUrl + ", IdDirectoryUrl: " + this.IdDirectoryUrl + ", Tenant: " + this.Tenant + ", ServiceBusEnvironmentUrl: " + this.ServiceBusEnvironment.getServiceUrl();
    }
}

