/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core;

import com.fifa.connectid.sdk.ValidationException;
import com.fifa.connectid.sdk.core.FifaConflictException;
import com.fifa.connectid.sdk.core.FifaConnectIdException;
import com.fifa.connectid.sdk.core.FifaDuplicateOfRegisteredPersonFoundException;
import com.fifa.connectid.sdk.core.FifaDuplicatedFacilityFoundException;
import com.fifa.connectid.sdk.core.FifaDuplicatedOrganisationFoundException;
import com.fifa.connectid.sdk.core.FifaDuplicatedPersonFoundException;
import com.fifa.connectid.sdk.core.FifaEntityDeletedException;
import com.fifa.connectid.sdk.core.FifaEntityNotFoundException;
import com.fifa.connectid.sdk.core.FifaOrganisationMergedException;
import com.fifa.connectid.sdk.core.FifaPersonMergedException;
import com.fifa.connectid.sdk.core.InvalidClientDataException;
import com.fifa.connectid.sdk.core.UnauthorizedException;
import com.fifa.connectid.sdk.core.api.models.AddRegistrationsRequestType;
import com.fifa.connectid.sdk.core.api.models.BulkDeactivateRegistrationsRequestType;
import com.fifa.connectid.sdk.core.api.models.BulkDeactivateRegistrationsResponseType;
import com.fifa.connectid.sdk.core.api.models.FacilityLocalType;
import com.fifa.connectid.sdk.core.api.models.FindFacilitiesRequestType;
import com.fifa.connectid.sdk.core.api.models.FindFacilitiesResponseType;
import com.fifa.connectid.sdk.core.api.models.FindOrganisationsRequestType;
import com.fifa.connectid.sdk.core.api.models.FindOrganisationsResponseType;
import com.fifa.connectid.sdk.core.api.models.GetDuplicatesOfRegisteredPersonResponseType;
import com.fifa.connectid.sdk.core.api.models.MemberAssociationResponseType;
import com.fifa.connectid.sdk.core.api.models.NationalAssociationsOnboardedRequestType;
import com.fifa.connectid.sdk.core.api.models.NationalAssociationsOnboardedResponseType;
import com.fifa.connectid.sdk.core.api.models.OrganisationLocalType;
import com.fifa.connectid.sdk.core.api.models.PersonDuplicateType;
import com.fifa.connectid.sdk.core.api.models.PersonType;
import com.fifa.connectid.sdk.core.api.models.RegistrationType;
import com.fifa.connectid.sdk.core.api.models.UpdateRegistrationsRequestType;
import com.fifa.connectid.sdk.core.hashing.HashingServiceClient;
import com.fifa.connectid.sdk.core.iddirectory.IdDirectoryServiceClient;
import com.fifa.connectid.sdk.core.xmlparser.models.PersonData;
import com.fifa.connectid.sdk.core.xmlparser.models.PersonName;
import com.fifa.connectservicebus.sdk.AuthenticationException;
import java.io.IOException;
import java.util.List;
import org.joda.time.LocalDate;

public interface FifaConnectIdClient {
    public PersonType getPerson(String var1) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, FifaEntityNotFoundException, InvalidClientDataException, FifaEntityDeletedException, ValidationException;

    public RegistrationType getPrimaryDataProviderRegistrationType(String var1) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, FifaEntityNotFoundException, InvalidClientDataException, FifaEntityDeletedException, ValidationException;

    public List<PersonDuplicateType> getPersonDuplicates(PersonData var1) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, ValidationException;

    public List<PersonDuplicateType> getPersonDuplicates(PersonData var1, List<String> var2) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, ValidationException;

    public GetDuplicatesOfRegisteredPersonResponseType getPersonDuplicatesExceptTrustedKnownDuplicates(String var1, List<String> var2) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, InvalidClientDataException, ValidationException;

    public List<OrganisationLocalType> getOrganisationDuplicates(OrganisationLocalType var1) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, ValidationException;

    public List<FacilityLocalType> getFacilityDuplicates(FacilityLocalType var1) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, ValidationException;

    public String registerPerson(PersonData var1) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, InvalidClientDataException, FifaDuplicatedPersonFoundException, ValidationException;

    public String registerPerson(PersonData var1, String var2) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, InvalidClientDataException, FifaDuplicatedPersonFoundException, ValidationException;

    public String forceRegisterPerson(PersonData var1) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, InvalidClientDataException, ValidationException;

    public String forceRegisterPerson(PersonData var1, String var2) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, InvalidClientDataException, ValidationException;

    public PersonType updatePerson(String var1, List<PersonName> var2, LocalDate var3, boolean var4) throws AuthenticationException, FifaDuplicateOfRegisteredPersonFoundException, FifaConnectIdException, UnauthorizedException, ValidationException;

    public PersonType updatePerson(String var1, List<PersonName> var2, LocalDate var3, String var4, boolean var5) throws AuthenticationException, FifaDuplicateOfRegisteredPersonFoundException, FifaConnectIdException, UnauthorizedException, ValidationException;

    public PersonType addRegistrations(AddRegistrationsRequestType var1, Boolean var2) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, InvalidClientDataException, FifaEntityNotFoundException, ValidationException;

    public PersonType updateRegistrations(UpdateRegistrationsRequestType var1, Boolean var2) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, InvalidClientDataException, FifaEntityNotFoundException, ValidationException;

    public OrganisationLocalType getOrganisation(String var1) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, FifaOrganisationMergedException, FifaEntityNotFoundException, InvalidClientDataException, ValidationException;

    public String registerOrganisation(OrganisationLocalType var1, Boolean var2) throws FifaConnectIdException, AuthenticationException, FifaDuplicatedOrganisationFoundException, UnauthorizedException, InvalidClientDataException, ValidationException;

    public String registerOrganisation(OrganisationLocalType var1) throws FifaConnectIdException, AuthenticationException, FifaDuplicatedOrganisationFoundException, UnauthorizedException, InvalidClientDataException, ValidationException;

    public PersonType mergePersons(String var1, String var2) throws FifaConnectIdException, FifaConflictException, AuthenticationException, UnauthorizedException, InvalidClientDataException, FifaEntityNotFoundException, ValidationException;

    public PersonType unmergePersons(String var1, String var2) throws FifaConnectIdException, FifaConflictException, AuthenticationException, UnauthorizedException, InvalidClientDataException, FifaEntityNotFoundException, ValidationException;

    public BulkDeactivateRegistrationsResponseType bulkDeactivateRegistrations(BulkDeactivateRegistrationsRequestType var1) throws FifaConnectIdException, InvalidClientDataException, AuthenticationException, UnauthorizedException, ValidationException;

    public OrganisationLocalType mergeOrganisations(String var1, String var2) throws FifaConnectIdException, FifaConflictException, AuthenticationException, UnauthorizedException, InvalidClientDataException, FifaEntityNotFoundException, ValidationException;

    public OrganisationLocalType unmergeOrganisations(String var1, String var2) throws FifaConnectIdException, FifaConflictException, AuthenticationException, UnauthorizedException, InvalidClientDataException, FifaEntityNotFoundException, ValidationException;

    public OrganisationLocalType updateOrganisation(OrganisationLocalType var1, Boolean var2) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, InvalidClientDataException, FifaEntityNotFoundException, FifaDuplicatedOrganisationFoundException, ValidationException;

    public OrganisationLocalType updateOrganisation(OrganisationLocalType var1) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, InvalidClientDataException, FifaEntityNotFoundException, FifaDuplicatedOrganisationFoundException, ValidationException;

    public FacilityLocalType getFacility(String var1) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, InvalidClientDataException, FifaEntityNotFoundException, ValidationException;

    public String registerFacility(FacilityLocalType var1, Boolean var2) throws FifaConnectIdException, AuthenticationException, FifaDuplicatedFacilityFoundException, UnauthorizedException, InvalidClientDataException, ValidationException;

    public String registerFacility(FacilityLocalType var1) throws FifaConnectIdException, AuthenticationException, FifaDuplicatedFacilityFoundException, UnauthorizedException, InvalidClientDataException, ValidationException;

    public FacilityLocalType updateFacility(FacilityLocalType var1, Boolean var2) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, InvalidClientDataException, FifaEntityNotFoundException, FifaDuplicatedFacilityFoundException, ValidationException;

    public FacilityLocalType updateFacility(FacilityLocalType var1) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, InvalidClientDataException, FifaEntityNotFoundException, FifaDuplicatedFacilityFoundException, ValidationException;

    public FindOrganisationsResponseType findOrganisations(FindOrganisationsRequestType var1) throws FifaConnectIdException, IOException, AuthenticationException, ValidationException;

    public FindFacilitiesResponseType findFacilities(FindFacilitiesRequestType var1) throws FifaConnectIdException, IOException, AuthenticationException, ValidationException;

    public NationalAssociationsOnboardedResponseType getAllNationalAssociationsOnboardedStatus() throws IOException, UnauthorizedException, FifaEntityNotFoundException, IOException, AuthenticationException, InvalidClientDataException, FifaConnectIdException;

    public NationalAssociationsOnboardedResponseType getNationalAssociationsOnboardedStatus(NationalAssociationsOnboardedRequestType var1) throws IOException, UnauthorizedException, FifaEntityNotFoundException, AuthenticationException, FifaConnectIdException, ValidationException;

    public MemberAssociationResponseType getMemberAssociationForFifaId(String var1) throws InvalidClientDataException, FifaEntityNotFoundException, FifaConnectIdException, AuthenticationException, UnauthorizedException, ValidationException;

    public void registerAsDataHolderOfPerson(String var1) throws ValidationException, AuthenticationException, UnauthorizedException, InvalidClientDataException, FifaPersonMergedException, FifaEntityNotFoundException, FifaEntityDeletedException, FifaConnectIdException;

    public List<String> getDataHoldersOfPerson(String var1) throws ValidationException, AuthenticationException, UnauthorizedException, InvalidClientDataException, FifaPersonMergedException, FifaEntityNotFoundException, FifaEntityDeletedException, FifaConnectIdException;

    public List<String> getMergedSecondaryFifaIdsForPerson(String var1) throws ValidationException, AuthenticationException, UnauthorizedException, InvalidClientDataException, FifaEntityNotFoundException, FifaConnectIdException;

    public HashingServiceClient getHashingClient();

    public IdDirectoryServiceClient getIdDirectoryClient();
}

