/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class SdkVersionHelper {
    private static final Attributes.Name titleAttribute = new Attributes.Name("Implementation-Title");
    private static final Attributes.Name versionAttribute = new Attributes.Name("Implementation-Version");

    public static String GetTechnologyWithVersion() {
        return "JAVA_" + SdkVersionHelper.TryGetVersion();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String TryGetVersion() {
        try {
            Enumeration<URL> resources = SdkVersionHelper.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                InputStream resourceStream = resources.nextElement().openStream();
                try {
                    String title;
                    Manifest manifest = new Manifest(resourceStream);
                    Attributes attributes = manifest.getMainAttributes();
                    if (!attributes.containsKey(titleAttribute) || !attributes.containsKey(versionAttribute) || !(title = attributes.get(titleAttribute).toString()).equals("fifa-connect-id-sdk")) continue;
                    String string = attributes.get(versionAttribute).toString();
                    return string;
                }
                finally {
                    if (resourceStream == null) continue;
                    resourceStream.close();
                }
            }
            return SdkVersionHelper.class.getPackage().getImplementationVersion();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return SdkVersionHelper.class.getPackage().getImplementationVersion();
    }
}

