/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.api.implementation;

import com.fifa.connectid.sdk.core.api.Facilitys;
import com.fifa.connectid.sdk.core.api.implementation.FIFAConnectIDIDDirectoryV6Impl;
import com.fifa.connectid.sdk.core.api.models.BadRequestResponseType;
import com.fifa.connectid.sdk.core.api.models.FacilityLocalType;
import com.fifa.connectid.sdk.core.api.models.FindFacilitiesRequestType;
import com.fifa.connectid.sdk.core.api.models.FindFacilitiesResponseType;
import com.fifa.connectid.sdk.core.api.models.GetFacilityDuplicatesResponseType;
import com.fifa.connectid.sdk.core.api.models.RegisterResponseType;
import com.fifa.connectid.sdk.core.api.models.TooManyRequestsResponseType;
import com.google.common.reflect.TypeToken;
import com.microsoft.rest.RestException;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class FacilitysImpl
implements Facilitys {
    private FacilitysService service;
    private FIFAConnectIDIDDirectoryV6Impl client;

    public FacilitysImpl(Retrofit retrofit, FIFAConnectIDIDDirectoryV6Impl client) {
        this.service = retrofit.create(FacilitysService.class);
        this.client = client;
    }

    @Override
    public Object getByFacilityfifaid(String facilityFifaId) {
        return this.getByFacilityfifaidWithServiceResponseAsync(facilityFifaId).toBlocking().single().body();
    }

    @Override
    public ServiceFuture<Object> getByFacilityfifaidAsync(String facilityFifaId, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByFacilityfifaidWithServiceResponseAsync(facilityFifaId), serviceCallback);
    }

    @Override
    public Observable<Object> getByFacilityfifaidAsync(String facilityFifaId) {
        return this.getByFacilityfifaidWithServiceResponseAsync(facilityFifaId).map(new Func1<ServiceResponse<Object>, Object>(){

            @Override
            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> getByFacilityfifaidWithServiceResponseAsync(String facilityFifaId) {
        if (facilityFifaId == null) {
            throw new IllegalArgumentException("Parameter facilityFifaId is required and cannot be null.");
        }
        return this.service.getByFacilityfifaid(facilityFifaId).flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            @Override
            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = FacilitysImpl.this.getByFacilityfifaidDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error(t);
                }
            }
        });
    }

    private ServiceResponse<Object> getByFacilityfifaidDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FacilityLocalType>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).register(503, new TypeToken<Void>(){}.getType()).build(response);
    }

    @Override
    public Object getDuplicates(FacilityLocalType body) {
        return this.getDuplicatesWithServiceResponseAsync(body).toBlocking().single().body();
    }

    @Override
    public ServiceFuture<Object> getDuplicatesAsync(FacilityLocalType body, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.getDuplicatesWithServiceResponseAsync(body), serviceCallback);
    }

    @Override
    public Observable<Object> getDuplicatesAsync(FacilityLocalType body) {
        return this.getDuplicatesWithServiceResponseAsync(body).map(new Func1<ServiceResponse<Object>, Object>(){

            @Override
            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> getDuplicatesWithServiceResponseAsync(FacilityLocalType body) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate(body);
        String xActorDetails = null;
        return this.service.getDuplicates(xActorDetails, body).flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            @Override
            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = FacilitysImpl.this.getDuplicatesDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error(t);
                }
            }
        });
    }

    @Override
    public Object getDuplicates(FacilityLocalType body, String xActorDetails) {
        return this.getDuplicatesWithServiceResponseAsync(body, xActorDetails).toBlocking().single().body();
    }

    @Override
    public ServiceFuture<Object> getDuplicatesAsync(FacilityLocalType body, String xActorDetails, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.getDuplicatesWithServiceResponseAsync(body, xActorDetails), serviceCallback);
    }

    @Override
    public Observable<Object> getDuplicatesAsync(FacilityLocalType body, String xActorDetails) {
        return this.getDuplicatesWithServiceResponseAsync(body, xActorDetails).map(new Func1<ServiceResponse<Object>, Object>(){

            @Override
            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> getDuplicatesWithServiceResponseAsync(FacilityLocalType body, String xActorDetails) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate(body);
        return this.service.getDuplicates(xActorDetails, body).flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            @Override
            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = FacilitysImpl.this.getDuplicatesDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error(t);
                }
            }
        });
    }

    private ServiceResponse<Object> getDuplicatesDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GetFacilityDuplicatesResponseType>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).register(503, new TypeToken<Void>(){}.getType()).build(response);
    }

    @Override
    public Object registerByForce(FacilityLocalType body) {
        return this.registerByForceWithServiceResponseAsync(body).toBlocking().single().body();
    }

    @Override
    public ServiceFuture<Object> registerByForceAsync(FacilityLocalType body, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.registerByForceWithServiceResponseAsync(body), serviceCallback);
    }

    @Override
    public Observable<Object> registerByForceAsync(FacilityLocalType body) {
        return this.registerByForceWithServiceResponseAsync(body).map(new Func1<ServiceResponse<Object>, Object>(){

            @Override
            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> registerByForceWithServiceResponseAsync(FacilityLocalType body) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate(body);
        Boolean force = null;
        String xActorDetails = null;
        return this.service.registerByForce(force, xActorDetails, body).flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            @Override
            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = FacilitysImpl.this.registerByForceDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error(t);
                }
            }
        });
    }

    @Override
    public Object registerByForce(FacilityLocalType body, Boolean force, String xActorDetails) {
        return this.registerByForceWithServiceResponseAsync(body, force, xActorDetails).toBlocking().single().body();
    }

    @Override
    public ServiceFuture<Object> registerByForceAsync(FacilityLocalType body, Boolean force, String xActorDetails, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.registerByForceWithServiceResponseAsync(body, force, xActorDetails), serviceCallback);
    }

    @Override
    public Observable<Object> registerByForceAsync(FacilityLocalType body, Boolean force, String xActorDetails) {
        return this.registerByForceWithServiceResponseAsync(body, force, xActorDetails).map(new Func1<ServiceResponse<Object>, Object>(){

            @Override
            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> registerByForceWithServiceResponseAsync(FacilityLocalType body, Boolean force, String xActorDetails) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate(body);
        return this.service.registerByForce(force, xActorDetails, body).flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            @Override
            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = FacilitysImpl.this.registerByForceDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error(t);
                }
            }
        });
    }

    private ServiceResponse<Object> registerByForceDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<RegisterResponseType>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(409, new TypeToken<GetFacilityDuplicatesResponseType>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).register(503, new TypeToken<Void>(){}.getType()).build(response);
    }

    @Override
    public Object updateByForce(FacilityLocalType body) {
        return this.updateByForceWithServiceResponseAsync(body).toBlocking().single().body();
    }

    @Override
    public ServiceFuture<Object> updateByForceAsync(FacilityLocalType body, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateByForceWithServiceResponseAsync(body), serviceCallback);
    }

    @Override
    public Observable<Object> updateByForceAsync(FacilityLocalType body) {
        return this.updateByForceWithServiceResponseAsync(body).map(new Func1<ServiceResponse<Object>, Object>(){

            @Override
            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> updateByForceWithServiceResponseAsync(FacilityLocalType body) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate(body);
        Boolean force = null;
        String xActorDetails = null;
        return this.service.updateByForce(force, xActorDetails, body).flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            @Override
            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = FacilitysImpl.this.updateByForceDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error(t);
                }
            }
        });
    }

    @Override
    public Object updateByForce(FacilityLocalType body, Boolean force, String xActorDetails) {
        return this.updateByForceWithServiceResponseAsync(body, force, xActorDetails).toBlocking().single().body();
    }

    @Override
    public ServiceFuture<Object> updateByForceAsync(FacilityLocalType body, Boolean force, String xActorDetails, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateByForceWithServiceResponseAsync(body, force, xActorDetails), serviceCallback);
    }

    @Override
    public Observable<Object> updateByForceAsync(FacilityLocalType body, Boolean force, String xActorDetails) {
        return this.updateByForceWithServiceResponseAsync(body, force, xActorDetails).map(new Func1<ServiceResponse<Object>, Object>(){

            @Override
            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> updateByForceWithServiceResponseAsync(FacilityLocalType body, Boolean force, String xActorDetails) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate(body);
        return this.service.updateByForce(force, xActorDetails, body).flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            @Override
            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = FacilitysImpl.this.updateByForceDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error(t);
                }
            }
        });
    }

    private ServiceResponse<Object> updateByForceDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FacilityLocalType>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).register(409, new TypeToken<GetFacilityDuplicatesResponseType>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).register(503, new TypeToken<Void>(){}.getType()).build(response);
    }

    @Override
    public Object find(FindFacilitiesRequestType body) {
        return this.findWithServiceResponseAsync(body).toBlocking().single().body();
    }

    @Override
    public ServiceFuture<Object> findAsync(FindFacilitiesRequestType body, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.findWithServiceResponseAsync(body), serviceCallback);
    }

    @Override
    public Observable<Object> findAsync(FindFacilitiesRequestType body) {
        return this.findWithServiceResponseAsync(body).map(new Func1<ServiceResponse<Object>, Object>(){

            @Override
            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> findWithServiceResponseAsync(FindFacilitiesRequestType body) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate(body);
        String xActorDetails = null;
        return this.service.find(xActorDetails, body).flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            @Override
            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = FacilitysImpl.this.findDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error(t);
                }
            }
        });
    }

    @Override
    public Object find(FindFacilitiesRequestType body, String xActorDetails) {
        return this.findWithServiceResponseAsync(body, xActorDetails).toBlocking().single().body();
    }

    @Override
    public ServiceFuture<Object> findAsync(FindFacilitiesRequestType body, String xActorDetails, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.findWithServiceResponseAsync(body, xActorDetails), serviceCallback);
    }

    @Override
    public Observable<Object> findAsync(FindFacilitiesRequestType body, String xActorDetails) {
        return this.findWithServiceResponseAsync(body, xActorDetails).map(new Func1<ServiceResponse<Object>, Object>(){

            @Override
            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> findWithServiceResponseAsync(FindFacilitiesRequestType body, String xActorDetails) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate(body);
        return this.service.find(xActorDetails, body).flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            @Override
            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = FacilitysImpl.this.findDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error(t);
                }
            }
        });
    }

    private ServiceResponse<Object> findDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FindFacilitiesResponseType>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).register(503, new TypeToken<Void>(){}.getType()).build(response);
    }

    static interface FacilitysService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectid.sdk.core.api.Facilitys getByFacilityfifaid"})
        @GET(value="api/v6/facility/get")
        public Observable<Response<ResponseBody>> getByFacilityfifaid(@Query(value="facilityFifaId") String var1);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectid.sdk.core.api.Facilitys getDuplicates"})
        @POST(value="api/v6/facility/getduplicates")
        public Observable<Response<ResponseBody>> getDuplicates(@Header(value="X-ActorDetails") String var1, @Body FacilityLocalType var2);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectid.sdk.core.api.Facilitys registerByForce"})
        @POST(value="api/v6/facility/register")
        public Observable<Response<ResponseBody>> registerByForce(@Query(value="force") Boolean var1, @Header(value="X-ActorDetails") String var2, @Body FacilityLocalType var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectid.sdk.core.api.Facilitys updateByForce"})
        @POST(value="api/v6/facility/update")
        public Observable<Response<ResponseBody>> updateByForce(@Query(value="force") Boolean var1, @Header(value="X-ActorDetails") String var2, @Body FacilityLocalType var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectid.sdk.core.api.Facilitys find"})
        @POST(value="api/v6/facility/find")
        public Observable<Response<ResponseBody>> find(@Header(value="X-ActorDetails") String var1, @Body FindFacilitiesRequestType var2);
    }
}

