/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.api.implementation;

import com.fifa.connectid.sdk.core.api.Hashs;
import com.fifa.connectid.sdk.core.api.implementation.FIFAConnectIDHashingV6Impl;
import com.fifa.connectid.sdk.core.api.models.BadRequestResponseType;
import com.fifa.connectid.sdk.core.api.models.HashedNameType;
import com.fifa.connectid.sdk.core.api.models.TooManyRequestsResponseType;
import com.google.common.reflect.TypeToken;
import com.microsoft.rest.RestException;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class HashsImpl
implements Hashs {
    private HashsService service;
    private FIFAConnectIDHashingV6Impl client;

    public HashsImpl(Retrofit retrofit, FIFAConnectIDHashingV6Impl client) {
        this.service = retrofit.create(HashsService.class);
        this.client = client;
    }

    @Override
    public Object computeByRequest(String lastName) {
        return this.computeByRequestWithServiceResponseAsync(lastName).toBlocking().single().body();
    }

    @Override
    public ServiceFuture<Object> computeByRequestAsync(String lastName, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.computeByRequestWithServiceResponseAsync(lastName), serviceCallback);
    }

    @Override
    public Observable<Object> computeByRequestAsync(String lastName) {
        return this.computeByRequestWithServiceResponseAsync(lastName).map(new Func1<ServiceResponse<Object>, Object>(){

            @Override
            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> computeByRequestWithServiceResponseAsync(String lastName) {
        if (lastName == null) {
            throw new IllegalArgumentException("Parameter lastName is required and cannot be null.");
        }
        String firstName = null;
        String prefer = null;
        return this.service.computeByRequest(firstName, lastName, prefer).flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            @Override
            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = HashsImpl.this.computeByRequestDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error(t);
                }
            }
        });
    }

    @Override
    public Object computeByRequest(String lastName, String firstName, String prefer) {
        return this.computeByRequestWithServiceResponseAsync(lastName, firstName, prefer).toBlocking().single().body();
    }

    @Override
    public ServiceFuture<Object> computeByRequestAsync(String lastName, String firstName, String prefer, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.computeByRequestWithServiceResponseAsync(lastName, firstName, prefer), serviceCallback);
    }

    @Override
    public Observable<Object> computeByRequestAsync(String lastName, String firstName, String prefer) {
        return this.computeByRequestWithServiceResponseAsync(lastName, firstName, prefer).map(new Func1<ServiceResponse<Object>, Object>(){

            @Override
            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> computeByRequestWithServiceResponseAsync(String lastName, String firstName, String prefer) {
        if (lastName == null) {
            throw new IllegalArgumentException("Parameter lastName is required and cannot be null.");
        }
        return this.service.computeByRequest(firstName, lastName, prefer).flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            @Override
            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = HashsImpl.this.computeByRequestDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error(t);
                }
            }
        });
    }

    private ServiceResponse<Object> computeByRequestDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<HashedNameType>>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).register(503, new TypeToken<Void>(){}.getType()).build(response);
    }

    static interface HashsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectid.sdk.core.api.Hashs computeByRequest"})
        @POST(value="api/v6/hash/compute")
        public Observable<Response<ResponseBody>> computeByRequest(@Query(value="firstName") String var1, @Query(value="lastName") String var2, @Header(value="prefer") String var3);
    }
}

