/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.api.implementation;

import com.fifa.connectid.sdk.core.api.Organisations;
import com.fifa.connectid.sdk.core.api.implementation.FIFAConnectIDIDDirectoryV6Impl;
import com.fifa.connectid.sdk.core.api.models.BadRequestResponseType;
import com.fifa.connectid.sdk.core.api.models.ConflictResponseType;
import com.fifa.connectid.sdk.core.api.models.FindOrganisationsRequestType;
import com.fifa.connectid.sdk.core.api.models.FindOrganisationsResponseType;
import com.fifa.connectid.sdk.core.api.models.GetActingOrganisationsResponseType;
import com.fifa.connectid.sdk.core.api.models.GetAllOrganisationsRequestType;
import com.fifa.connectid.sdk.core.api.models.GetAllOrganisationsResponseType;
import com.fifa.connectid.sdk.core.api.models.GetOrganisationDuplicatesResponseType;
import com.fifa.connectid.sdk.core.api.models.MemberAssociationResponseType;
import com.fifa.connectid.sdk.core.api.models.MergeOrganisationsRequestType;
import com.fifa.connectid.sdk.core.api.models.NationalAssociationsOnboardedRequestType;
import com.fifa.connectid.sdk.core.api.models.NationalAssociationsOnboardedResponseType;
import com.fifa.connectid.sdk.core.api.models.OrganisationGetByOrganisationfifaidHeaders;
import com.fifa.connectid.sdk.core.api.models.OrganisationLocalType;
import com.fifa.connectid.sdk.core.api.models.RegisterResponseType;
import com.fifa.connectid.sdk.core.api.models.TooManyRequestsResponseType;
import com.fifa.connectid.sdk.core.api.models.UnmergeOrganisationsRequestType;
import com.google.common.reflect.TypeToken;
import com.microsoft.rest.RestException;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.ServiceResponseWithHeaders;
import com.microsoft.rest.Validator;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class OrganisationsImpl
implements Organisations {
    private OrganisationsService service;
    private FIFAConnectIDIDDirectoryV6Impl client;

    public OrganisationsImpl(Retrofit retrofit, FIFAConnectIDIDDirectoryV6Impl client) {
        this.service = retrofit.create(OrganisationsService.class);
        this.client = client;
    }

    @Override
    public Object getByOrganisationfifaid(String organisationFifaId) {
        return this.getByOrganisationfifaidWithServiceResponseAsync(organisationFifaId).toBlocking().single().body();
    }

    @Override
    public ServiceFuture<Object> getByOrganisationfifaidAsync(String organisationFifaId, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromHeaderResponse(this.getByOrganisationfifaidWithServiceResponseAsync(organisationFifaId), serviceCallback);
    }

    @Override
    public Observable<Object> getByOrganisationfifaidAsync(String organisationFifaId) {
        return this.getByOrganisationfifaidWithServiceResponseAsync(organisationFifaId).map(new Func1<ServiceResponseWithHeaders<Object, OrganisationGetByOrganisationfifaidHeaders>, Object>(){

            @Override
            public Object call(ServiceResponseWithHeaders<Object, OrganisationGetByOrganisationfifaidHeaders> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponseWithHeaders<Object, OrganisationGetByOrganisationfifaidHeaders>> getByOrganisationfifaidWithServiceResponseAsync(String organisationFifaId) {
        if (organisationFifaId == null) {
            throw new IllegalArgumentException("Parameter organisationFifaId is required and cannot be null.");
        }
        return this.service.getByOrganisationfifaid(organisationFifaId).flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponseWithHeaders<Object, OrganisationGetByOrganisationfifaidHeaders>>>(){

            @Override
            public Observable<ServiceResponseWithHeaders<Object, OrganisationGetByOrganisationfifaidHeaders>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponseWithHeaders<Object, OrganisationGetByOrganisationfifaidHeaders> clientResponse = OrganisationsImpl.this.getByOrganisationfifaidDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error(t);
                }
            }
        });
    }

    private ServiceResponseWithHeaders<Object, OrganisationGetByOrganisationfifaidHeaders> getByOrganisationfifaidDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<OrganisationLocalType>(){}.getType()).register(301, new TypeToken<OrganisationLocalType>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).register(503, new TypeToken<Void>(){}.getType()).buildWithHeaders(response, OrganisationGetByOrganisationfifaidHeaders.class);
    }

    @Override
    public Object getActingOrganisations() {
        return this.getActingOrganisationsWithServiceResponseAsync().toBlocking().single().body();
    }

    @Override
    public ServiceFuture<Object> getActingOrganisationsAsync(ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.getActingOrganisationsWithServiceResponseAsync(), serviceCallback);
    }

    @Override
    public Observable<Object> getActingOrganisationsAsync() {
        return this.getActingOrganisationsWithServiceResponseAsync().map(new Func1<ServiceResponse<Object>, Object>(){

            @Override
            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> getActingOrganisationsWithServiceResponseAsync() {
        return this.service.getActingOrganisations().flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            @Override
            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = OrganisationsImpl.this.getActingOrganisationsDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error(t);
                }
            }
        });
    }

    private ServiceResponse<Object> getActingOrganisationsDelegate(Response<ResponseBody> response) throws RestException, IOException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GetActingOrganisationsResponseType>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).register(503, new TypeToken<Void>(){}.getType()).build(response);
    }

    @Override
    public Object getDuplicates(OrganisationLocalType body) {
        return this.getDuplicatesWithServiceResponseAsync(body).toBlocking().single().body();
    }

    @Override
    public ServiceFuture<Object> getDuplicatesAsync(OrganisationLocalType body, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.getDuplicatesWithServiceResponseAsync(body), serviceCallback);
    }

    @Override
    public Observable<Object> getDuplicatesAsync(OrganisationLocalType body) {
        return this.getDuplicatesWithServiceResponseAsync(body).map(new Func1<ServiceResponse<Object>, Object>(){

            @Override
            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> getDuplicatesWithServiceResponseAsync(OrganisationLocalType body) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate(body);
        String xActorDetails = null;
        return this.service.getDuplicates(xActorDetails, body).flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            @Override
            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = OrganisationsImpl.this.getDuplicatesDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error(t);
                }
            }
        });
    }

    @Override
    public Object getDuplicates(OrganisationLocalType body, String xActorDetails) {
        return this.getDuplicatesWithServiceResponseAsync(body, xActorDetails).toBlocking().single().body();
    }

    @Override
    public ServiceFuture<Object> getDuplicatesAsync(OrganisationLocalType body, String xActorDetails, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.getDuplicatesWithServiceResponseAsync(body, xActorDetails), serviceCallback);
    }

    @Override
    public Observable<Object> getDuplicatesAsync(OrganisationLocalType body, String xActorDetails) {
        return this.getDuplicatesWithServiceResponseAsync(body, xActorDetails).map(new Func1<ServiceResponse<Object>, Object>(){

            @Override
            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> getDuplicatesWithServiceResponseAsync(OrganisationLocalType body, String xActorDetails) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate(body);
        return this.service.getDuplicates(xActorDetails, body).flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            @Override
            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = OrganisationsImpl.this.getDuplicatesDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error(t);
                }
            }
        });
    }

    private ServiceResponse<Object> getDuplicatesDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GetOrganisationDuplicatesResponseType>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).register(503, new TypeToken<Void>(){}.getType()).build(response);
    }

    @Override
    public Object registerByForce(OrganisationLocalType body) {
        return this.registerByForceWithServiceResponseAsync(body).toBlocking().single().body();
    }

    @Override
    public ServiceFuture<Object> registerByForceAsync(OrganisationLocalType body, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.registerByForceWithServiceResponseAsync(body), serviceCallback);
    }

    @Override
    public Observable<Object> registerByForceAsync(OrganisationLocalType body) {
        return this.registerByForceWithServiceResponseAsync(body).map(new Func1<ServiceResponse<Object>, Object>(){

            @Override
            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> registerByForceWithServiceResponseAsync(OrganisationLocalType body) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate(body);
        Boolean force = null;
        String xActorDetails = null;
        return this.service.registerByForce(force, xActorDetails, body).flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            @Override
            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = OrganisationsImpl.this.registerByForceDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error(t);
                }
            }
        });
    }

    @Override
    public Object registerByForce(OrganisationLocalType body, Boolean force, String xActorDetails) {
        return this.registerByForceWithServiceResponseAsync(body, force, xActorDetails).toBlocking().single().body();
    }

    @Override
    public ServiceFuture<Object> registerByForceAsync(OrganisationLocalType body, Boolean force, String xActorDetails, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.registerByForceWithServiceResponseAsync(body, force, xActorDetails), serviceCallback);
    }

    @Override
    public Observable<Object> registerByForceAsync(OrganisationLocalType body, Boolean force, String xActorDetails) {
        return this.registerByForceWithServiceResponseAsync(body, force, xActorDetails).map(new Func1<ServiceResponse<Object>, Object>(){

            @Override
            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> registerByForceWithServiceResponseAsync(OrganisationLocalType body, Boolean force, String xActorDetails) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate(body);
        return this.service.registerByForce(force, xActorDetails, body).flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            @Override
            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = OrganisationsImpl.this.registerByForceDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error(t);
                }
            }
        });
    }

    private ServiceResponse<Object> registerByForceDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<RegisterResponseType>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(409, new TypeToken<GetOrganisationDuplicatesResponseType>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).register(503, new TypeToken<Void>(){}.getType()).build(response);
    }

    @Override
    public Object merge(MergeOrganisationsRequestType body) {
        return this.mergeWithServiceResponseAsync(body).toBlocking().single().body();
    }

    @Override
    public ServiceFuture<Object> mergeAsync(MergeOrganisationsRequestType body, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.mergeWithServiceResponseAsync(body), serviceCallback);
    }

    @Override
    public Observable<Object> mergeAsync(MergeOrganisationsRequestType body) {
        return this.mergeWithServiceResponseAsync(body).map(new Func1<ServiceResponse<Object>, Object>(){

            @Override
            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> mergeWithServiceResponseAsync(MergeOrganisationsRequestType body) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate(body);
        String xActorDetails = null;
        return this.service.merge(xActorDetails, body).flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            @Override
            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = OrganisationsImpl.this.mergeDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error(t);
                }
            }
        });
    }

    @Override
    public Object merge(MergeOrganisationsRequestType body, String xActorDetails) {
        return this.mergeWithServiceResponseAsync(body, xActorDetails).toBlocking().single().body();
    }

    @Override
    public ServiceFuture<Object> mergeAsync(MergeOrganisationsRequestType body, String xActorDetails, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.mergeWithServiceResponseAsync(body, xActorDetails), serviceCallback);
    }

    @Override
    public Observable<Object> mergeAsync(MergeOrganisationsRequestType body, String xActorDetails) {
        return this.mergeWithServiceResponseAsync(body, xActorDetails).map(new Func1<ServiceResponse<Object>, Object>(){

            @Override
            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> mergeWithServiceResponseAsync(MergeOrganisationsRequestType body, String xActorDetails) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate(body);
        return this.service.merge(xActorDetails, body).flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            @Override
            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = OrganisationsImpl.this.mergeDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error(t);
                }
            }
        });
    }

    private ServiceResponse<Object> mergeDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<OrganisationLocalType>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).register(409, new TypeToken<ConflictResponseType>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).register(503, new TypeToken<Void>(){}.getType()).build(response);
    }

    @Override
    public Object unmerge(UnmergeOrganisationsRequestType body) {
        return this.unmergeWithServiceResponseAsync(body).toBlocking().single().body();
    }

    @Override
    public ServiceFuture<Object> unmergeAsync(UnmergeOrganisationsRequestType body, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.unmergeWithServiceResponseAsync(body), serviceCallback);
    }

    @Override
    public Observable<Object> unmergeAsync(UnmergeOrganisationsRequestType body) {
        return this.unmergeWithServiceResponseAsync(body).map(new Func1<ServiceResponse<Object>, Object>(){

            @Override
            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> unmergeWithServiceResponseAsync(UnmergeOrganisationsRequestType body) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate(body);
        String xActorDetails = null;
        return this.service.unmerge(xActorDetails, body).flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            @Override
            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = OrganisationsImpl.this.unmergeDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error(t);
                }
            }
        });
    }

    @Override
    public Object unmerge(UnmergeOrganisationsRequestType body, String xActorDetails) {
        return this.unmergeWithServiceResponseAsync(body, xActorDetails).toBlocking().single().body();
    }

    @Override
    public ServiceFuture<Object> unmergeAsync(UnmergeOrganisationsRequestType body, String xActorDetails, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.unmergeWithServiceResponseAsync(body, xActorDetails), serviceCallback);
    }

    @Override
    public Observable<Object> unmergeAsync(UnmergeOrganisationsRequestType body, String xActorDetails) {
        return this.unmergeWithServiceResponseAsync(body, xActorDetails).map(new Func1<ServiceResponse<Object>, Object>(){

            @Override
            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> unmergeWithServiceResponseAsync(UnmergeOrganisationsRequestType body, String xActorDetails) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate(body);
        return this.service.unmerge(xActorDetails, body).flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            @Override
            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = OrganisationsImpl.this.unmergeDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error(t);
                }
            }
        });
    }

    private ServiceResponse<Object> unmergeDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<OrganisationLocalType>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).register(409, new TypeToken<ConflictResponseType>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).register(503, new TypeToken<Void>(){}.getType()).build(response);
    }

    @Override
    public Object updateByForce(OrganisationLocalType body) {
        return this.updateByForceWithServiceResponseAsync(body).toBlocking().single().body();
    }

    @Override
    public ServiceFuture<Object> updateByForceAsync(OrganisationLocalType body, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateByForceWithServiceResponseAsync(body), serviceCallback);
    }

    @Override
    public Observable<Object> updateByForceAsync(OrganisationLocalType body) {
        return this.updateByForceWithServiceResponseAsync(body).map(new Func1<ServiceResponse<Object>, Object>(){

            @Override
            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> updateByForceWithServiceResponseAsync(OrganisationLocalType body) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate(body);
        Boolean force = null;
        String xActorDetails = null;
        return this.service.updateByForce(force, xActorDetails, body).flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            @Override
            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = OrganisationsImpl.this.updateByForceDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error(t);
                }
            }
        });
    }

    @Override
    public Object updateByForce(OrganisationLocalType body, Boolean force, String xActorDetails) {
        return this.updateByForceWithServiceResponseAsync(body, force, xActorDetails).toBlocking().single().body();
    }

    @Override
    public ServiceFuture<Object> updateByForceAsync(OrganisationLocalType body, Boolean force, String xActorDetails, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateByForceWithServiceResponseAsync(body, force, xActorDetails), serviceCallback);
    }

    @Override
    public Observable<Object> updateByForceAsync(OrganisationLocalType body, Boolean force, String xActorDetails) {
        return this.updateByForceWithServiceResponseAsync(body, force, xActorDetails).map(new Func1<ServiceResponse<Object>, Object>(){

            @Override
            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> updateByForceWithServiceResponseAsync(OrganisationLocalType body, Boolean force, String xActorDetails) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate(body);
        return this.service.updateByForce(force, xActorDetails, body).flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            @Override
            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = OrganisationsImpl.this.updateByForceDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error(t);
                }
            }
        });
    }

    private ServiceResponse<Object> updateByForceDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<OrganisationLocalType>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).register(409, new TypeToken<GetOrganisationDuplicatesResponseType>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).register(503, new TypeToken<Void>(){}.getType()).build(response);
    }

    @Override
    public Object find(FindOrganisationsRequestType body) {
        return this.findWithServiceResponseAsync(body).toBlocking().single().body();
    }

    @Override
    public ServiceFuture<Object> findAsync(FindOrganisationsRequestType body, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.findWithServiceResponseAsync(body), serviceCallback);
    }

    @Override
    public Observable<Object> findAsync(FindOrganisationsRequestType body) {
        return this.findWithServiceResponseAsync(body).map(new Func1<ServiceResponse<Object>, Object>(){

            @Override
            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> findWithServiceResponseAsync(FindOrganisationsRequestType body) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate(body);
        String xActorDetails = null;
        return this.service.find(xActorDetails, body).flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            @Override
            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = OrganisationsImpl.this.findDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error(t);
                }
            }
        });
    }

    @Override
    public Object find(FindOrganisationsRequestType body, String xActorDetails) {
        return this.findWithServiceResponseAsync(body, xActorDetails).toBlocking().single().body();
    }

    @Override
    public ServiceFuture<Object> findAsync(FindOrganisationsRequestType body, String xActorDetails, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.findWithServiceResponseAsync(body, xActorDetails), serviceCallback);
    }

    @Override
    public Observable<Object> findAsync(FindOrganisationsRequestType body, String xActorDetails) {
        return this.findWithServiceResponseAsync(body, xActorDetails).map(new Func1<ServiceResponse<Object>, Object>(){

            @Override
            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> findWithServiceResponseAsync(FindOrganisationsRequestType body, String xActorDetails) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate(body);
        return this.service.find(xActorDetails, body).flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            @Override
            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = OrganisationsImpl.this.findDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error(t);
                }
            }
        });
    }

    private ServiceResponse<Object> findDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FindOrganisationsResponseType>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).register(503, new TypeToken<Void>(){}.getType()).build(response);
    }

    @Override
    public Object getAll(GetAllOrganisationsRequestType body) {
        return this.getAllWithServiceResponseAsync(body).toBlocking().single().body();
    }

    @Override
    public ServiceFuture<Object> getAllAsync(GetAllOrganisationsRequestType body, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.getAllWithServiceResponseAsync(body), serviceCallback);
    }

    @Override
    public Observable<Object> getAllAsync(GetAllOrganisationsRequestType body) {
        return this.getAllWithServiceResponseAsync(body).map(new Func1<ServiceResponse<Object>, Object>(){

            @Override
            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> getAllWithServiceResponseAsync(GetAllOrganisationsRequestType body) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate(body);
        String xActorDetails = null;
        return this.service.getAll(xActorDetails, body).flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            @Override
            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = OrganisationsImpl.this.getAllDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error(t);
                }
            }
        });
    }

    @Override
    public Object getAll(GetAllOrganisationsRequestType body, String xActorDetails) {
        return this.getAllWithServiceResponseAsync(body, xActorDetails).toBlocking().single().body();
    }

    @Override
    public ServiceFuture<Object> getAllAsync(GetAllOrganisationsRequestType body, String xActorDetails, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.getAllWithServiceResponseAsync(body, xActorDetails), serviceCallback);
    }

    @Override
    public Observable<Object> getAllAsync(GetAllOrganisationsRequestType body, String xActorDetails) {
        return this.getAllWithServiceResponseAsync(body, xActorDetails).map(new Func1<ServiceResponse<Object>, Object>(){

            @Override
            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> getAllWithServiceResponseAsync(GetAllOrganisationsRequestType body, String xActorDetails) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate(body);
        return this.service.getAll(xActorDetails, body).flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            @Override
            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = OrganisationsImpl.this.getAllDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error(t);
                }
            }
        });
    }

    private ServiceResponse<Object> getAllDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GetAllOrganisationsResponseType>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).register(503, new TypeToken<Void>(){}.getType()).build(response);
    }

    @Override
    public Object getMemberAssociationsOnboardedStatus(NationalAssociationsOnboardedRequestType body) {
        return this.getMemberAssociationsOnboardedStatusWithServiceResponseAsync(body).toBlocking().single().body();
    }

    @Override
    public ServiceFuture<Object> getMemberAssociationsOnboardedStatusAsync(NationalAssociationsOnboardedRequestType body, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.getMemberAssociationsOnboardedStatusWithServiceResponseAsync(body), serviceCallback);
    }

    @Override
    public Observable<Object> getMemberAssociationsOnboardedStatusAsync(NationalAssociationsOnboardedRequestType body) {
        return this.getMemberAssociationsOnboardedStatusWithServiceResponseAsync(body).map(new Func1<ServiceResponse<Object>, Object>(){

            @Override
            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> getMemberAssociationsOnboardedStatusWithServiceResponseAsync(NationalAssociationsOnboardedRequestType body) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate(body);
        String xActorDetails = null;
        return this.service.getMemberAssociationsOnboardedStatus(xActorDetails, body).flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            @Override
            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = OrganisationsImpl.this.getMemberAssociationsOnboardedStatusDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error(t);
                }
            }
        });
    }

    @Override
    public Object getMemberAssociationsOnboardedStatus(NationalAssociationsOnboardedRequestType body, String xActorDetails) {
        return this.getMemberAssociationsOnboardedStatusWithServiceResponseAsync(body, xActorDetails).toBlocking().single().body();
    }

    @Override
    public ServiceFuture<Object> getMemberAssociationsOnboardedStatusAsync(NationalAssociationsOnboardedRequestType body, String xActorDetails, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.getMemberAssociationsOnboardedStatusWithServiceResponseAsync(body, xActorDetails), serviceCallback);
    }

    @Override
    public Observable<Object> getMemberAssociationsOnboardedStatusAsync(NationalAssociationsOnboardedRequestType body, String xActorDetails) {
        return this.getMemberAssociationsOnboardedStatusWithServiceResponseAsync(body, xActorDetails).map(new Func1<ServiceResponse<Object>, Object>(){

            @Override
            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> getMemberAssociationsOnboardedStatusWithServiceResponseAsync(NationalAssociationsOnboardedRequestType body, String xActorDetails) {
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate(body);
        return this.service.getMemberAssociationsOnboardedStatus(xActorDetails, body).flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            @Override
            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = OrganisationsImpl.this.getMemberAssociationsOnboardedStatusDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error(t);
                }
            }
        });
    }

    private ServiceResponse<Object> getMemberAssociationsOnboardedStatusDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<NationalAssociationsOnboardedResponseType>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).register(503, new TypeToken<Void>(){}.getType()).build(response);
    }

    @Override
    public Object getMemberAssociationForFifaIdByOrganisationfifaid(String organisationFifaId) {
        return this.getMemberAssociationForFifaIdByOrganisationfifaidWithServiceResponseAsync(organisationFifaId).toBlocking().single().body();
    }

    @Override
    public ServiceFuture<Object> getMemberAssociationForFifaIdByOrganisationfifaidAsync(String organisationFifaId, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.getMemberAssociationForFifaIdByOrganisationfifaidWithServiceResponseAsync(organisationFifaId), serviceCallback);
    }

    @Override
    public Observable<Object> getMemberAssociationForFifaIdByOrganisationfifaidAsync(String organisationFifaId) {
        return this.getMemberAssociationForFifaIdByOrganisationfifaidWithServiceResponseAsync(organisationFifaId).map(new Func1<ServiceResponse<Object>, Object>(){

            @Override
            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    @Override
    public Observable<ServiceResponse<Object>> getMemberAssociationForFifaIdByOrganisationfifaidWithServiceResponseAsync(String organisationFifaId) {
        if (organisationFifaId == null) {
            throw new IllegalArgumentException("Parameter organisationFifaId is required and cannot be null.");
        }
        return this.service.getMemberAssociationForFifaIdByOrganisationfifaid(organisationFifaId).flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            @Override
            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse<Object> clientResponse = OrganisationsImpl.this.getMemberAssociationForFifaIdByOrganisationfifaidDelegate(response);
                    return Observable.just(clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error(t);
                }
            }
        });
    }

    private ServiceResponse<Object> getMemberAssociationForFifaIdByOrganisationfifaidDelegate(Response<ResponseBody> response) throws RestException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<MemberAssociationResponseType>(){}.getType()).register(400, new TypeToken<BadRequestResponseType>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).register(429, new TypeToken<TooManyRequestsResponseType>(){}.getType()).register(500, new TypeToken<Void>(){}.getType()).register(503, new TypeToken<Void>(){}.getType()).build(response);
    }

    static interface OrganisationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectid.sdk.core.api.Organisations getByOrganisationfifaid"})
        @GET(value="api/v6/organisation/get")
        public Observable<Response<ResponseBody>> getByOrganisationfifaid(@Query(value="organisationFifaId") String var1);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectid.sdk.core.api.Organisations getActingOrganisations"})
        @GET(value="api/v6/organisation/getactingorganisations")
        public Observable<Response<ResponseBody>> getActingOrganisations();

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectid.sdk.core.api.Organisations getDuplicates"})
        @POST(value="api/v6/organisation/getduplicates")
        public Observable<Response<ResponseBody>> getDuplicates(@Header(value="X-ActorDetails") String var1, @Body OrganisationLocalType var2);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectid.sdk.core.api.Organisations registerByForce"})
        @POST(value="api/v6/organisation/register")
        public Observable<Response<ResponseBody>> registerByForce(@Query(value="force") Boolean var1, @Header(value="X-ActorDetails") String var2, @Body OrganisationLocalType var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectid.sdk.core.api.Organisations merge"})
        @POST(value="api/v6/organisation/merge")
        public Observable<Response<ResponseBody>> merge(@Header(value="X-ActorDetails") String var1, @Body MergeOrganisationsRequestType var2);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectid.sdk.core.api.Organisations unmerge"})
        @POST(value="api/v6/organisation/unmerge")
        public Observable<Response<ResponseBody>> unmerge(@Header(value="X-ActorDetails") String var1, @Body UnmergeOrganisationsRequestType var2);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectid.sdk.core.api.Organisations updateByForce"})
        @POST(value="api/v6/organisation/update")
        public Observable<Response<ResponseBody>> updateByForce(@Query(value="force") Boolean var1, @Header(value="X-ActorDetails") String var2, @Body OrganisationLocalType var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectid.sdk.core.api.Organisations find"})
        @POST(value="api/v6/organisation/find")
        public Observable<Response<ResponseBody>> find(@Header(value="X-ActorDetails") String var1, @Body FindOrganisationsRequestType var2);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectid.sdk.core.api.Organisations getAll"})
        @POST(value="api/v6/organisation/getall")
        public Observable<Response<ResponseBody>> getAll(@Header(value="X-ActorDetails") String var1, @Body GetAllOrganisationsRequestType var2);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectid.sdk.core.api.Organisations getMemberAssociationsOnboardedStatus"})
        @POST(value="api/v6/organisation/getmemberassociationsonboardedstatus")
        public Observable<Response<ResponseBody>> getMemberAssociationsOnboardedStatus(@Header(value="X-ActorDetails") String var1, @Body NationalAssociationsOnboardedRequestType var2);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.fifa.connectid.sdk.core.api.Organisations getMemberAssociationForFifaIdByOrganisationfifaid"})
        @GET(value="api/v6/organisation/getmemberassociationforfifaid")
        public Observable<Response<ResponseBody>> getMemberAssociationForFifaIdByOrganisationfifaid(@Query(value="organisationFifaId") String var1);
    }
}

