/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.apimodelvalidation;

import com.fifa.connectid.sdk.ValidationException;
import com.fifa.connectid.sdk.core.apimodelvalidation.ModelValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.XsdSchemaValuesResolver;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ApiModelValidator {
    static final XsdSchemaValuesResolver xsdSchemaValuesResolver = new XsdSchemaValuesResolver();

    static <T> void cannotBeNull(T validationSubject, String validationSubjectName) throws ValidationException {
        if (validationSubject == null) {
            throw new ValidationException(String.format("%s cannot be null", validationSubjectName));
        }
    }

    public static void cannotBeNullOrWhitespace(String textValue, String validationSubjectName) throws ValidationException {
        if (ApiModelValidator.isNullOrWhiteSpace(textValue)) {
            throw new ValidationException(String.format("%s cannot be null or empty", validationSubjectName));
        }
    }

    static boolean isNullOrWhiteSpace(String textValue) {
        return textValue == null || textValue.trim().length() == 0;
    }

    static void mustMatchPattern(String textValue, String pattern, String validationSubjectName) throws ValidationException {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("%s (pattern) cannot be null", validationSubjectName));
        }
        ApiModelValidator.cannotBeNull(textValue, validationSubjectName);
        if (!textValue.matches(pattern)) {
            throw new ValidationException(String.format("[%s] Validation against pattern: %s failed. Provided value: %s", validationSubjectName, pattern, textValue));
        }
    }

    public static <T extends Enum<T>> void mustBeNullOrMatchEnumValue(String textValue, Class<T> enumType, String validationSubjectName) throws ValidationException {
        if (textValue == null) {
            return;
        }
        ApiModelValidator.mustMatchEnumValue(textValue, enumType, validationSubjectName);
    }

    static <T extends Enum<T>> void mustMatchEnumValue(String textValue, Class<T> enumType, String validationSubjectName) throws ValidationException {
        if (enumType == null) {
            throw new IllegalArgumentException(String.format("%s (enumType) cannot be null", validationSubjectName));
        }
        List<String> validValues = ApiModelValidator.GetEnumValues(enumType);
        boolean ignoreCase = true;
        ApiModelValidator.oneOf(textValue, validValues, validationSubjectName, ignoreCase);
    }

    static <T extends Enum<T>> void mustBeNullOrMatchSchemaEnumValue(String textValue, Class<T> enumType, String validationSubjectName) throws ValidationException {
        if (textValue == null) {
            return;
        }
        ApiModelValidator.mustMatchSchemaEnumValue(textValue, enumType, validationSubjectName);
    }

    static <T extends Enum<T>> void mustMatchSchemaEnumValue(String textValue, Class<T> enumType, String validationSubjectName) throws ValidationException {
        if (enumType == null) {
            throw new IllegalArgumentException(String.format("%s (enumType) cannot be null", validationSubjectName));
        }
        ArrayList<String> validValues = xsdSchemaValuesResolver.getValues(enumType);
        boolean ignoreCase = false;
        ApiModelValidator.oneOf(textValue, validValues, validationSubjectName, ignoreCase);
    }

    static void oneOf(String textValue, List<String> validValues, String validationSubjectName, boolean ignoreCase) throws ValidationException {
        for (String enumValue : validValues) {
            if (!(ignoreCase ? enumValue.equalsIgnoreCase(textValue) : enumValue.equals(textValue))) continue;
            return;
        }
        throw new ValidationException(String.format("%s was %s, but must be one of: %s", validationSubjectName, textValue, String.join((CharSequence)", ", validValues)));
    }

    static <T extends Comparable<T>> void mustBeNullOrGreaterOrEqual(T value, T minValue, String validationSubjectName) throws ValidationException {
        if (value == null) {
            return;
        }
        ApiModelValidator.mustBeGreaterOrEqual(value, minValue, validationSubjectName);
    }

    public static <T extends Comparable<T>> void mustBeGreaterOrEqual(T value, T minValue, String validationSubjectName) throws ValidationException {
        if (minValue == null) {
            throw new IllegalArgumentException(String.format("%s (minValue) cannot be null", validationSubjectName));
        }
        if (value == null || value.compareTo(minValue) < 0) {
            throw new ValidationException(String.format("%s must be greater or equal to %s, but was %s", validationSubjectName, minValue, value));
        }
    }

    static <T extends Comparable<T>> void mustBeNullOrLessOrEqual(T value, T maxValue, String validationSubjectName) throws ValidationException {
        if (value == null) {
            return;
        }
        ApiModelValidator.mustBeLessOrEqual(value, maxValue, validationSubjectName);
    }

    static <T extends Comparable<T>> void mustBeLessOrEqual(T value, T maxValue, String validationSubjectName) throws ValidationException {
        if (maxValue == null) {
            throw new IllegalArgumentException(String.format("%s (maxValue) cannot be null", validationSubjectName));
        }
        if (value == null || value.compareTo(maxValue) > 0) {
            throw new ValidationException(String.format("%s must be less or equal to %s, but was %s", validationSubjectName, maxValue, value));
        }
    }

    static <T> void validateAllowNull(T validationSubject, ModelValidator<T> modelValidator, String validationSubjectName) throws ValidationException {
        if (modelValidator == null) {
            throw new IllegalArgumentException(String.format("%s (modelValidator) cannot be null", validationSubjectName));
        }
        if (validationSubject != null) {
            modelValidator.validate(validationSubject, validationSubjectName);
        }
    }

    static <T> void validateDoNotAllowNull(T validationSubject, ModelValidator<T> modelValidator, String validationSubjectName) throws ValidationException {
        if (modelValidator == null) {
            throw new IllegalArgumentException(String.format("%s (modelValidator) cannot be null", validationSubjectName));
        }
        ApiModelValidator.cannotBeNull(validationSubject, validationSubjectName);
        modelValidator.validate(validationSubject, validationSubjectName);
    }

    static <T> void validateAllInCollectionIfNotNull(Collection<T> collectionOfValidationSubjects, ModelValidator<T> modelValidator, String validationSubjectName) throws ValidationException {
        if (collectionOfValidationSubjects == null) {
            return;
        }
        ApiModelValidator.validateAllInCollection(collectionOfValidationSubjects, modelValidator, validationSubjectName);
    }

    public static <T> void validateAllInCollection(Collection<T> collectionOfValidationSubjects, ModelValidator<T> modelValidator, String validationSubjectName) throws ValidationException {
        if (modelValidator == null) {
            throw new IllegalArgumentException(String.format("%s (modelValidator) cannot be null", validationSubjectName));
        }
        ApiModelValidator.cannotBeNull(collectionOfValidationSubjects, validationSubjectName);
        String validationSubjectNameWithGet = validationSubjectName + ".get(";
        int count = 0;
        for (T object : collectionOfValidationSubjects) {
            modelValidator.validate(object, validationSubjectNameWithGet + count + ")");
            ++count;
        }
    }

    private static <T extends Enum<T>> List<String> GetEnumValues(Class<T> enumType) {
        ArrayList<String> enumValues = new ArrayList<String>();
        Method valueMethod = null;
        try {
            valueMethod = enumType.getMethod("value", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        for (Enum enumValue : (Enum[])enumType.getEnumConstants()) {
            String name = ApiModelValidator.GetEnumValue(valueMethod, enumValue);
            enumValues.add(name);
        }
        return enumValues;
    }

    private static <T extends Enum<T>> String GetEnumValue(Method valueMethod, T enumValue) {
        if (valueMethod != null) {
            try {
                return valueMethod.invoke(enumValue, new Object[0]).toString();
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return enumValue.name();
    }
}

