/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.apimodelvalidation;

import com.fifa.connectid.sdk.ValidationException;
import com.fifa.connectid.sdk.core.api.models.FindFacilitiesRequestType;
import com.fifa.connectid.sdk.core.apimodelvalidation.ApiModelValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.FifaIdValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.ModelValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.SearchAddressTypeValidator;

class FindFacilitiesRequestTypeValidator
implements ModelValidator<FindFacilitiesRequestType> {
    FindFacilitiesRequestTypeValidator() {
    }

    @Override
    public void validate(FindFacilitiesRequestType request, String validationSubjectName) throws ValidationException {
        String typeName = FindFacilitiesRequestType.class.getSimpleName();
        validationSubjectName = ApiModelValidator.isNullOrWhiteSpace(validationSubjectName) ? typeName : validationSubjectName;
        ApiModelValidator.cannotBeNull(request, validationSubjectName);
        String numberOfResultsPropertyName = validationSubjectName + ".numberOfResults";
        ApiModelValidator.mustBeNullOrGreaterOrEqual(request.numberOfResults(), 1, numberOfResultsPropertyName);
        ApiModelValidator.mustBeNullOrLessOrEqual(request.numberOfResults(), 50, numberOfResultsPropertyName);
        FifaIdValidator fifaIdValidator = new FifaIdValidator();
        ApiModelValidator.validateAllowNull(request.organisationFIFAId(), fifaIdValidator, validationSubjectName + ".organisationFIFAId");
        ApiModelValidator.validateAllowNull(request.parentFacilityFIFAId(), fifaIdValidator, validationSubjectName + ".parentFacilityFIFAId");
        ApiModelValidator.validateAllowNull(request.officialAddress(), new SearchAddressTypeValidator(), validationSubjectName + ".officialAddress");
    }
}

