/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.apimodelvalidation;

import com.fifa.connectid.sdk.ValidationException;
import com.fifa.connectid.sdk.core.api.models.HashedNameType;
import com.fifa.connectid.sdk.core.apimodelvalidation.ApiModelValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.ModelValidator;

class HashedNameTypeValidator
implements ModelValidator<HashedNameType> {
    HashedNameTypeValidator() {
    }

    @Override
    public void validate(HashedNameType hashedName, String validationSubjectName) throws ValidationException {
        String typeName = HashedNameType.class.getSimpleName();
        validationSubjectName = ApiModelValidator.isNullOrWhiteSpace(validationSubjectName) ? typeName : validationSubjectName;
        ApiModelValidator.cannotBeNull(hashedName, validationSubjectName);
        ApiModelValidator.cannotBeNullOrWhitespace(hashedName.type(), validationSubjectName + ".type");
        ApiModelValidator.cannotBeNullOrWhitespace(hashedName.hash(), validationSubjectName + ".hash");
        String proximityScorePropertyName = validationSubjectName + ".proximityScore";
        ApiModelValidator.mustBeGreaterOrEqual(hashedName.proximityScore(), 0.0, proximityScorePropertyName);
        ApiModelValidator.mustBeLessOrEqual(hashedName.proximityScore(), 1.0, proximityScorePropertyName);
    }
}

