/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.apimodelvalidation;

import com.fifa.connectid.sdk.ValidationException;
import com.fifa.connectid.sdk.core.api.models.NationalIdentifierType;
import com.fifa.connectid.sdk.core.apimodelvalidation.ApiModelValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.ModelValidator;
import com.fifa.fc.ISO3166CountryCode;
import com.fifa.fc.NationalIdentifierNatureType;

class NationalIdentifierTypeValidator
implements ModelValidator<NationalIdentifierType> {
    NationalIdentifierTypeValidator() {
    }

    @Override
    public void validate(NationalIdentifierType identifierType, String validationSubjectName) throws ValidationException {
        String typeName = NationalIdentifierType.class.getSimpleName();
        validationSubjectName = ApiModelValidator.isNullOrWhiteSpace(validationSubjectName) ? typeName : validationSubjectName;
        ApiModelValidator.cannotBeNull(identifierType, validationSubjectName);
        ApiModelValidator.cannotBeNullOrWhitespace(identifierType.identifier(), validationSubjectName + ".identifier");
        ApiModelValidator.mustMatchSchemaEnumValue(identifierType.country(), ISO3166CountryCode.class, validationSubjectName + ".country");
        ApiModelValidator.mustMatchEnumValue(identifierType.nationalIdentifierNature(), NationalIdentifierNatureType.class, validationSubjectName + ".nationalIdentifierNature");
    }
}

