/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.apimodelvalidation;

import com.fifa.connectid.sdk.ValidationException;
import com.fifa.connectid.sdk.core.api.models.PlayerRegistrationType;
import com.fifa.connectid.sdk.core.apimodelvalidation.ApiModelValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.FifaIdValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.ModelValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.SystemIdValidator;
import com.fifa.fc.DisciplineType;
import com.fifa.fc.PlayerRegistrationNatureType;
import com.fifa.fc.RegistrationLevelType;
import com.fifa.fc.SimpleStatusType;

class PlayerRegistrationTypeValidator
implements ModelValidator<PlayerRegistrationType> {
    PlayerRegistrationTypeValidator() {
    }

    @Override
    public void validate(PlayerRegistrationType playerRegistration, String validationSubjectName) throws ValidationException {
        String typeName = PlayerRegistrationType.class.getSimpleName();
        validationSubjectName = ApiModelValidator.isNullOrWhiteSpace(validationSubjectName) ? typeName : validationSubjectName;
        ApiModelValidator.cannotBeNull(playerRegistration, validationSubjectName);
        ApiModelValidator.validateDoNotAllowNull(playerRegistration.organisationFIFAId(), new FifaIdValidator(), validationSubjectName + ".organisationFIFAId");
        ApiModelValidator.mustMatchEnumValue(playerRegistration.level(), RegistrationLevelType.class, validationSubjectName + ".level");
        ApiModelValidator.mustMatchEnumValue(playerRegistration.status(), SimpleStatusType.class, validationSubjectName + ".status");
        ApiModelValidator.mustMatchEnumValue(playerRegistration.discipline(), DisciplineType.class, validationSubjectName + ".discipline");
        ApiModelValidator.mustBeNullOrMatchEnumValue(playerRegistration.registrationNature(), PlayerRegistrationNatureType.class, validationSubjectName + ".registrationNature");
        ApiModelValidator.validateAllowNull(playerRegistration.systemId(), new SystemIdValidator(), validationSubjectName + ".systemId");
    }
}

