/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.apimodelvalidation;

import com.fifa.connectid.sdk.ValidationException;
import com.fifa.connectid.sdk.core.api.models.UpdatePersonRequestType;
import com.fifa.connectid.sdk.core.apimodelvalidation.ApiModelValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.FifaIdValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.HashedNameTypeValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.ModelValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.ValidationConstants;
import com.fifa.fc.GenderType;

class UpdatePersonRequestTypeValidator
implements ModelValidator<UpdatePersonRequestType> {
    UpdatePersonRequestTypeValidator() {
    }

    @Override
    public void validate(UpdatePersonRequestType updatePersonRequest, String validationSubjectName) throws ValidationException {
        validationSubjectName = ApiModelValidator.isNullOrWhiteSpace(validationSubjectName) ? UpdatePersonRequestType.class.getSimpleName() : validationSubjectName;
        ApiModelValidator.cannotBeNull(updatePersonRequest, validationSubjectName);
        ApiModelValidator.validateDoNotAllowNull(updatePersonRequest.personId(), new FifaIdValidator(), validationSubjectName + ".personId");
        ApiModelValidator.validateAllInCollectionIfNotNull(updatePersonRequest.nameHashes(), new HashedNameTypeValidator(), validationSubjectName + ".nameHashes");
        ApiModelValidator.mustBeNullOrGreaterOrEqual(updatePersonRequest.dateOfBirth(), ValidationConstants.DATE_OF_BIRTH_LOWER_BOUNDARY, validationSubjectName + ".dateOfBirth");
        ApiModelValidator.mustBeNullOrMatchEnumValue(updatePersonRequest.gender(), GenderType.class, validationSubjectName + ".gender");
    }
}

