/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.apimodelvalidation;

import com.fifa.connectid.sdk.core.xsdschemavalidator.XsdSchemasDirectoryResolver;
import com.fifa.connectid.sdk.util.ResourcePath;
import com.fifa.connectid.sdk.util.ResourceReader;
import com.fifa.fc.ISO3166CountryCode;
import com.fifa.fc.ISO6392Type;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XsdSchemaValuesResolver {
    private final String directoryContainingXsdFiles = new XsdSchemasDirectoryResolver().getDirectory();
    private final Map<Class, ArrayList<String>> schemaEnumValues = new HashMap<Class, ArrayList<String>>(){
        {
            this.put(ISO3166CountryCode.class, XsdSchemaValuesResolver.this.loadSchemaValues("iso3166-country-code.xsd"));
            this.put(ISO6392Type.class, XsdSchemaValuesResolver.this.loadSchemaValues("iso639-2-language-code.xsd"));
        }
    };

    public ArrayList<String> getValues(Class classType) {
        if (this.schemaEnumValues.containsKey(classType)) {
            return this.schemaEnumValues.get(classType);
        }
        throw new IllegalStateException(String.format("There are no values from xsd file for type %s", classType.toString()));
    }

    private ArrayList<String> loadSchemaValues(String xsdFileName) {
        try {
            ResourcePath xsdFilePath = this.getPathFromIncludesSubDirectory(xsdFileName);
            ArrayList<String> values2 = new ArrayList<String>();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ResourceReader().readToStream(xsdFilePath));
            NodeList restrictionNodesList = document.getElementsByTagName("xsd:restriction");
            Node restrictionNode = restrictionNodesList.item(0);
            NodeList enumerationNodes = restrictionNode.getChildNodes();
            int enumerationNodesCount = enumerationNodes.getLength();
            for (int i = 0; i < enumerationNodesCount; ++i) {
                Node enumerationNode = enumerationNodes.item(i);
                if (!enumerationNode.getNodeName().equals("xsd:enumeration")) continue;
                String value = ((Element)enumerationNode).getAttribute("value");
                values2.add(value);
            }
            return values2;
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            String exceptionMessage = String.format("Error when trying to load schema values for file %s", xsdFileName);
            throw new IllegalStateException(exceptionMessage, exception);
        }
    }

    private ResourcePath getPathFromIncludesSubDirectory(String fileName) throws FileNotFoundException {
        ResourcePath pathToAnExistingFile = new ResourcePath(this.directoryContainingXsdFiles, "includes", fileName);
        if (!new ResourceReader().exists(pathToAnExistingFile)) {
            throw new FileNotFoundException(String.format("File could not be found: %s", pathToAnExistingFile));
        }
        return pathToAnExistingFile;
    }
}

