/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.enhancements;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fifa.connectid.sdk.core.api.implementation.FIFAConnectIDHashingV6Impl;
import com.fifa.connectid.sdk.core.api.implementation.FIFAConnectIDIDDirectoryV6Impl;
import com.fifa.connectid.sdk.core.api.models.AddRegistrationsRequestType;
import com.fifa.connectid.sdk.core.api.models.AddressType;
import com.fifa.connectid.sdk.core.api.models.BadRequestResponseType;
import com.fifa.connectid.sdk.core.api.models.ConflictResponseType;
import com.fifa.connectid.sdk.core.api.models.DetailsItemType;
import com.fifa.connectid.sdk.core.api.models.FacilityLocalType;
import com.fifa.connectid.sdk.core.api.models.FieldType;
import com.fifa.connectid.sdk.core.api.models.FindFacilitiesRequestType;
import com.fifa.connectid.sdk.core.api.models.FindFacilitiesResponseType;
import com.fifa.connectid.sdk.core.api.models.FindOrganisationsRequestType;
import com.fifa.connectid.sdk.core.api.models.FindOrganisationsResponseType;
import com.fifa.connectid.sdk.core.api.models.FoundFacilityLocalType;
import com.fifa.connectid.sdk.core.api.models.FoundOrganisationLocalType;
import com.fifa.connectid.sdk.core.api.models.GetDuplicatesByFIFAIdRequestType;
import com.fifa.connectid.sdk.core.api.models.GetDuplicatesOfRegisteredPersonResponseType;
import com.fifa.connectid.sdk.core.api.models.GetDuplicatesRequestType;
import com.fifa.connectid.sdk.core.api.models.GetDuplicatesResponseType;
import com.fifa.connectid.sdk.core.api.models.HashedNameType;
import com.fifa.connectid.sdk.core.api.models.LocalNameType;
import com.fifa.connectid.sdk.core.api.models.MatchOfficialRegistrationType;
import com.fifa.connectid.sdk.core.api.models.MergeOrganisationsRequestType;
import com.fifa.connectid.sdk.core.api.models.MergePersonsRequestType;
import com.fifa.connectid.sdk.core.api.models.NationalIdentifierType;
import com.fifa.connectid.sdk.core.api.models.OrganisationLocalType;
import com.fifa.connectid.sdk.core.api.models.OrganisationOfficialRegistrationType;
import com.fifa.connectid.sdk.core.api.models.PersonDuplicateMatchType;
import com.fifa.connectid.sdk.core.api.models.PersonDuplicateType;
import com.fifa.connectid.sdk.core.api.models.PersonRegistrationContextType;
import com.fifa.connectid.sdk.core.api.models.PersonRegistrationsType;
import com.fifa.connectid.sdk.core.api.models.PersonType;
import com.fifa.connectid.sdk.core.api.models.PictureEmbeddedType;
import com.fifa.connectid.sdk.core.api.models.PictureLinkType;
import com.fifa.connectid.sdk.core.api.models.PictureType;
import com.fifa.connectid.sdk.core.api.models.PlayerRegistrationType;
import com.fifa.connectid.sdk.core.api.models.RegisterPersonRequestType;
import com.fifa.connectid.sdk.core.api.models.RegisterResponseType;
import com.fifa.connectid.sdk.core.api.models.RegistrationType;
import com.fifa.connectid.sdk.core.api.models.SearchAddressType;
import com.fifa.connectid.sdk.core.api.models.SupportedDisciplineType;
import com.fifa.connectid.sdk.core.api.models.TeamOfficialRegistrationType;
import com.fifa.connectid.sdk.core.api.models.TooManyRequestsResponseType;
import com.fifa.connectid.sdk.core.api.models.UnmergeOrganisationsRequestType;
import com.fifa.connectid.sdk.core.api.models.UnmergePersonsRequestType;
import com.fifa.connectid.sdk.core.api.models.UpdatePersonRequestType;
import com.fifa.connectid.sdk.core.api.models.UpdateRegistrationsRequestType;
import com.fifa.connectid.sdk.core.enhancements.CollectionUtils;
import com.fifa.connectid.sdk.core.enhancements.Func2;
import com.fifa.connectid.sdk.core.xmlparser.models.PersonName;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ObjectFormatter {
    public static String toJson(Object obj) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            return "Could not serialize an object.";
        }
    }

    public static String toString(HashedNameType hashedName) {
        return hashedName.hash() + " of type " + hashedName.type() + " with score " + hashedName.proximityScore();
    }

    public static String toString(DetailsItemType details) {
        return details.key() + " : " + details.value();
    }

    public static String toString(BadRequestResponseType badRequestResponse) {
        return badRequestResponse.message() + " : " + ObjectFormatter.toJson(badRequestResponse.details());
    }

    public static String toString(TooManyRequestsResponseType tooManyRequestsResponseType) {
        return tooManyRequestsResponseType.message();
    }

    public static String toString(GetDuplicatesRequestType request) {
        List<HashedNameType> hashes = request.nameHashes();
        String gender = request.person().gender();
        String hashesString = hashes.isEmpty() ? "Empty list of hashes" : "One of the hashes: " + ObjectFormatter.toString(hashes.get(0));
        String dateOfBirthString = ", date of birth: " + request.person().dateOfBirth();
        String genderString = ", gender: " + (gender == null ? "empty" : gender);
        String localIdString = ", local id: " + (request.localId() == null ? "empty" : request.localId());
        String organizationsIdsString = ", organisations ids: " + (request.organisationsFIFAIds() == null ? "empty" : Joiner.on(", ").join(request.organisationsFIFAIds()));
        return hashesString + dateOfBirthString + genderString + localIdString + organizationsIdsString;
    }

    public static String toString(GetDuplicatesByFIFAIdRequestType request) {
        String trustedOrganizationsIdsString = ", trusted organisations ids: " + (request.trustedOrganisationsFIFAIds() == null ? "empty" : Joiner.on(", ").join(request.trustedOrganisationsFIFAIds()));
        return "person fifa id: " + request.personFIFAId() + trustedOrganizationsIdsString;
    }

    public static String toString(RegisterPersonRequestType request) {
        List<HashedNameType> hashes = request.nameHashes();
        String gender = request.person().gender();
        String hashesString = hashes.isEmpty() ? "Empty list of hashes" : "One of the hashes: " + ObjectFormatter.toString(hashes.get(0));
        String dateOfBirthString = ", date of birth: " + request.person().dateOfBirth();
        String genderString = ", gender: " + (gender == null ? "empty" : gender);
        String localIdString = ", local id: " + (request.localId() == null ? "empty" : request.localId());
        return hashesString + dateOfBirthString + genderString + localIdString;
    }

    public static String toString(PersonDuplicateMatchType personDuplicateMatch) {
        String queried = "Queried: " + personDuplicateMatch.queriedHash() + " / " + personDuplicateMatch.queriedDateOfBirth() + ". ";
        String matched = "Matched: " + personDuplicateMatch.matchedHash() + " / " + personDuplicateMatch.matchedDateOfBirth() + ".";
        return queried + matched;
    }

    public static String toString(PersonDuplicateType duplicatedPerson) {
        return duplicatedPerson.personFifaId() + " with score " + duplicatedPerson.proximityScore() + ". " + ObjectFormatter.toString(duplicatedPerson.duplicateMatchType()) + " " + ObjectFormatter.toString(duplicatedPerson.personRegistrationContext());
    }

    public static String toString(PersonRegistrationContextType registrationContext) {
        return "Registration date: " + registrationContext.registrationDate().toString() + ".";
    }

    public static String toString(GetDuplicatesResponseType getDuplicatesResponse) {
        List<PersonDuplicateType> duplicates = getDuplicatesResponse.duplicates();
        if (duplicates.isEmpty()) {
            return "Empty list of duplicates";
        }
        ArrayList<String> duplicatesStr = new ArrayList<String>();
        for (PersonDuplicateType duplicate : duplicates) {
            duplicatesStr.add(ObjectFormatter.toString(duplicate));
        }
        return "Duplicates: " + Joiner.on(", ").join(duplicatesStr);
    }

    public static String toString(GetDuplicatesOfRegisteredPersonResponseType getDuplicatesResponse) {
        List<PersonDuplicateType> duplicates = getDuplicatesResponse.duplicates();
        if (duplicates.isEmpty()) {
            return "Empty list of duplicates";
        }
        ArrayList<String> duplicatesStr = new ArrayList<String>();
        for (PersonDuplicateType duplicate : duplicates) {
            duplicatesStr.add(ObjectFormatter.toString(duplicate));
        }
        return "Duplicates: " + Joiner.on(", ").join(duplicatesStr);
    }

    public static String toString(RegisterResponseType registerResponse) {
        return "ID: " + registerResponse.uniqueFifaId();
    }

    public static String toString(PersonType person) {
        ArrayList<String> ids = new ArrayList<String>();
        for (PlayerRegistrationType playerRegistrationType : person.playerRegistrations()) {
            if (ids.contains(playerRegistrationType.organisationFIFAId())) continue;
            ids.add(playerRegistrationType.organisationFIFAId());
        }
        for (TeamOfficialRegistrationType teamOfficialRegistrationType : person.teamOfficialRegistrations()) {
            if (ids.contains(teamOfficialRegistrationType.organisationFIFAId())) continue;
            ids.add(teamOfficialRegistrationType.organisationFIFAId());
        }
        for (MatchOfficialRegistrationType matchOfficialRegistrationType : person.matchOfficialRegistrations()) {
            if (ids.contains(matchOfficialRegistrationType.organisationFIFAId())) continue;
            ids.add(matchOfficialRegistrationType.organisationFIFAId());
        }
        for (OrganisationOfficialRegistrationType organisationOfficialRegistrationType : person.organisationOfficialRegistrations()) {
            if (ids.contains(organisationOfficialRegistrationType.organisationFIFAId())) continue;
            ids.add(organisationOfficialRegistrationType.organisationFIFAId());
        }
        return "DateOfBirth: " + person.dateOfBirth() + " Associated with organisations: [" + Joiner.on(", ").join(ids) + "]";
    }

    public static String toString(OrganisationLocalType organisation) {
        return "ID: " + organisation.organisationFIFAId() + " InternationalName: " + organisation.internationalName() + " ShortName: " + organisation.internationalShortName() + " Nature: " + organisation.organisationNature();
    }

    public static String toString(FoundOrganisationLocalType organisation) {
        return "ID: " + organisation.organisationFIFAId() + " InternationalName: " + organisation.internationalName() + " ShortName: " + organisation.internationalShortName() + " Nature: " + organisation.organisationNature();
    }

    public static String toString(FoundFacilityLocalType facility) {
        return "ID: " + facility.facilityFIFAId() + " InternationalName: " + facility.internationalName() + " ShortName: " + facility.internationalShortName() + " Organisation: " + facility.organisationFIFAId();
    }

    public static String toString(RegistrationType registration) {
        return "'" + registration.status() + "' registration for '" + registration.organisationFIFAId() + "' organisation'";
    }

    public static String toString(PlayerRegistrationType registration) {
        return "'" + registration.status() + "' registration for '" + registration.organisationFIFAId() + "' organisation in '" + registration.discipline() + "' discipline at '" + registration.level() + "' level.";
    }

    public static String toString(TeamOfficialRegistrationType registration) {
        return "'" + registration.status() + "' registration for '" + registration.organisationFIFAId() + "' organisation in '" + registration.discipline() + "' discipline as '" + registration.teamOfficialRole() + "' role.";
    }

    public static String toString(MatchOfficialRegistrationType registration) {
        return "'" + registration.status() + "' registration for '" + registration.organisationFIFAId() + "' organisation in '" + registration.discipline() + "' discipline as '" + registration.matchOfficialRole() + "' role.";
    }

    public static String toString(OrganisationOfficialRegistrationType registration) {
        return "'" + registration.status() + "' registration for '" + registration.organisationFIFAId() + "' organisation as '" + registration.organisationOfficialRole() + "' role.";
    }

    public static String toString(FIFAConnectIDHashingV6Impl fifaConnectIDHashingV3) {
        return "BaseUrl: " + fifaConnectIDHashingV3.restClient().retrofit().baseUrl().toString();
    }

    public static String toString(PersonRegistrationsType registrationsType) {
        return ObjectFormatter.toJson(registrationsType);
    }

    public static String toString(FIFAConnectIDIDDirectoryV6Impl fifaConnectIDIDDirectoryV3) {
        return "BaseUrl: " + fifaConnectIDIDDirectoryV3.restClient().retrofit().baseUrl().toString();
    }

    public static String toString(LocalNameType nameType) {
        return "Name: " + nameType.name() + ", ShortName: " + nameType.shortName() + ", Language: " + nameType.language();
    }

    public static String toString(UpdateRegistrationsRequestType requestType) {
        return "PersonId: " + requestType.personId();
    }

    public static String toString(AddRegistrationsRequestType requestType) {
        return "PersonId: " + requestType.personId();
    }

    public static String toString(AddressType addressType) {
        return "Address: " + addressType.address() + ", Country: " + addressType.country() + ", PostalCode: " + addressType.postalCode() + ", Region: " + addressType.region() + ", Town" + addressType.town();
    }

    public static String toString(SupportedDisciplineType disciplineType) {
        return "Discipline: " + disciplineType.discipline() + ", Gender: " + disciplineType.gender();
    }

    public static String toString(PictureType pictureType) {
        Object pictureTypeString = "";
        if (pictureType.pictureEmbedded() != null) {
            pictureTypeString = (String)pictureTypeString + "Embeded: " + ObjectFormatter.toString(pictureType.pictureEmbedded());
        }
        if (pictureType.pictureLink() != null) {
            pictureTypeString = (String)pictureTypeString + "PictureLink: " + ObjectFormatter.toString(pictureType.pictureLink());
        }
        return pictureTypeString;
    }

    public static String toString(PictureEmbeddedType pictureEmbeddedType) {
        return "Value: " + pictureEmbeddedType.value() + ", ContentType: " + pictureEmbeddedType.contentType();
    }

    public static String toString(PictureLinkType pictureLinkType) {
        return "Link: " + pictureLinkType.pictureLink() + ", MimeType: " + pictureLinkType.mimeType();
    }

    public static String toString(NationalIdentifierType identifierType) {
        return "Country: " + identifierType.country() + ", Description: " + identifierType.description() + ", Identifier: " + identifierType.identifier() + ", NationalIdentifierNature: " + identifierType.nationalIdentifierNature() + ", DateFrom: " + identifierType.dateFrom() + ", DateTo: " + identifierType.dateTo();
    }

    public static String toString(UpdatePersonRequestType requestType) {
        return "PersonId: " + requestType.personId() + ", DateOfBirth: " + requestType.dateOfBirth() + ", NameHashes: " + requestType.nameHashes();
    }

    public static String toString(FacilityLocalType facilityType) {
        return "ID: " + facilityType.facilityFIFAId() + ", InternationalName: " + facilityType.internationalName() + ", ShortName: " + facilityType.internationalShortName() + ", Organisation: " + facilityType.organisationFIFAId() + ", Parent facility: " + facilityType.parentFacilityFIFAId();
    }

    public static String toString(FieldType fieldType) {
        return "OrderNumber: " + fieldType.orderNumber() + ", Discipline: " + fieldType.discipline() + ", GroundNature: " + fieldType.groundNature() + ", Capacity: " + fieldType.capacity();
    }

    public static String toString(MergeOrganisationsRequestType mergeOrganisationsRequestType) {
        return "PrimaryOrganisationFIFAId: " + mergeOrganisationsRequestType.primaryOrganisationFIFAId() + ", SecondaryOrganisationFIFAId: " + mergeOrganisationsRequestType.secondaryOrganisationFIFAId();
    }

    public static String toString(UnmergeOrganisationsRequestType unmergeOrganisationsRequestType) {
        return "PrimaryOrganisationId: " + unmergeOrganisationsRequestType.primaryOrganisationFIFAId() + ", SecondaryOrganisationId: " + unmergeOrganisationsRequestType.secondaryOrganisationFIFAId();
    }

    public static String toString(MergePersonsRequestType mergePersonsRequestType) {
        return "PrimaryPersonId: " + mergePersonsRequestType.primaryPersonFIFAId() + ", SecondaryPersonId: " + mergePersonsRequestType.secondaryPersonFIFAId();
    }

    public static String toString(UnmergePersonsRequestType unmergePersonsRequestType) {
        return "PrimaryPersonId: " + unmergePersonsRequestType.primaryPersonFIFAId() + ", SecondaryPersonId: " + unmergePersonsRequestType.secondaryPersonFIFAId();
    }

    public static String toString(List<PersonName> personNames) {
        return StringUtils.join(CollectionUtils.select(personNames, new Func2<PersonName, Object>(){

            @Override
            public Object invoke(PersonName arg) {
                return arg.toString();
            }
        }), ", ");
    }

    public static String toString(FindFacilitiesRequestType requestType) {
        return ObjectFormatter.toJson(requestType);
    }

    public static String toString(FindFacilitiesResponseType responseType) {
        return ObjectFormatter.toJson(responseType);
    }

    public static String toString(FindOrganisationsRequestType requestType) {
        return ObjectFormatter.toJson(requestType);
    }

    public static String toString(FindOrganisationsResponseType responseType) {
        return ObjectFormatter.toJson(responseType);
    }

    public static String toString(SearchAddressType searchAddressType) {
        return ObjectFormatter.toJson(searchAddressType);
    }

    public static String toString(ConflictResponseType conflictResponseType) {
        return conflictResponseType == null ? "" : conflictResponseType.message();
    }
}

