/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.errorhandling;

import com.fifa.connectid.sdk.core.InvalidClientDataException;
import com.fifa.connectid.sdk.core.api.models.BadRequestResponseType;
import com.fifa.connectid.sdk.core.api.models.DetailsItemType;
import com.fifa.connectid.sdk.core.errorhandling.ErrorResponseHandler;
import com.google.common.base.Joiner;
import com.microsoft.rest.ServiceResponse;
import java.lang.invoke.CallSite;
import java.util.ArrayList;

public class BadRequestHandler
implements ErrorResponseHandler {
    @Override
    public void Handle(ServiceResponse<Object> serviceResponse) throws InvalidClientDataException {
        Object body = serviceResponse.body();
        if (serviceResponse.response().code() == 400 && body instanceof BadRequestResponseType) {
            String message = BadRequestHandler.formatMessage((BadRequestResponseType)body);
            throw new InvalidClientDataException(message, (BadRequestResponseType)body, serviceResponse);
        }
    }

    private static String formatMessage(BadRequestResponseType body) {
        String message = "The service responded with status code 400. " + body.message();
        if (body.details() != null && !body.details().isEmpty()) {
            ArrayList<CallSite> ids = new ArrayList<CallSite>();
            for (DetailsItemType details : body.details()) {
                ids.add((CallSite)((Object)(details.key() + ": " + details.value())));
            }
            message = message + ": { " + Joiner.on("; ").join(ids) + " }";
        }
        return message;
    }
}

