/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.errorhandling;

import com.fifa.connectid.sdk.core.FifaDuplicatedFacilityFoundException;
import com.fifa.connectid.sdk.core.api.models.FacilityLocalType;
import com.fifa.connectid.sdk.core.api.models.GetFacilityDuplicatesResponseType;
import com.fifa.connectid.sdk.core.enhancements.DuplicateExceptionMessageFormatter;
import com.fifa.connectid.sdk.core.errorhandling.ErrorResponseHandler;
import com.microsoft.rest.ServiceResponse;
import java.util.ArrayList;

public class DuplicatedFacilityFoundHandler
implements ErrorResponseHandler {
    @Override
    public void Handle(ServiceResponse<Object> serviceResponse) throws FifaDuplicatedFacilityFoundException {
        Object body = serviceResponse.body();
        ArrayList<String> ids = new ArrayList<String>();
        if (serviceResponse.response().code() == 409 && body instanceof GetFacilityDuplicatesResponseType) {
            GetFacilityDuplicatesResponseType responseBody = (GetFacilityDuplicatesResponseType)body;
            if (responseBody.duplicates() != null && !responseBody.duplicates().isEmpty()) {
                for (FacilityLocalType duplicate : responseBody.duplicates()) {
                    ids.add(duplicate.facilityFIFAId());
                }
            }
            throw new FifaDuplicatedFacilityFoundException(DuplicateExceptionMessageFormatter.format(ids), responseBody, serviceResponse);
        }
    }
}

