/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.errorhandling;

import com.fifa.connectid.sdk.core.FifaDuplicatedOrganisationFoundException;
import com.fifa.connectid.sdk.core.api.models.GetOrganisationDuplicatesResponseType;
import com.fifa.connectid.sdk.core.api.models.OrganisationLocalType;
import com.fifa.connectid.sdk.core.enhancements.DuplicateExceptionMessageFormatter;
import com.fifa.connectid.sdk.core.errorhandling.ErrorResponseHandler;
import com.microsoft.rest.ServiceResponse;
import java.util.ArrayList;

public class DuplicatedOrganisationFoundHandler
implements ErrorResponseHandler {
    @Override
    public void Handle(ServiceResponse<Object> serviceResponse) throws FifaDuplicatedOrganisationFoundException {
        Object body = serviceResponse.body();
        ArrayList<String> ids = new ArrayList<String>();
        if (serviceResponse.response().code() == 409 && body instanceof GetOrganisationDuplicatesResponseType) {
            GetOrganisationDuplicatesResponseType responseBody = (GetOrganisationDuplicatesResponseType)body;
            if (responseBody.duplicates() != null && !responseBody.duplicates().isEmpty()) {
                for (OrganisationLocalType duplicate : responseBody.duplicates()) {
                    ids.add(duplicate.organisationFIFAId());
                }
            }
            throw new FifaDuplicatedOrganisationFoundException(DuplicateExceptionMessageFormatter.format(ids), responseBody, serviceResponse);
        }
    }
}

