/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.errorhandling;

import com.fifa.connectid.sdk.core.FifaDuplicatedPersonFoundException;
import com.fifa.connectid.sdk.core.api.models.GetDuplicatesResponseType;
import com.fifa.connectid.sdk.core.api.models.PersonDuplicateType;
import com.fifa.connectid.sdk.core.enhancements.DuplicateExceptionMessageFormatter;
import com.fifa.connectid.sdk.core.errorhandling.ErrorResponseHandler;
import com.microsoft.rest.ServiceResponse;
import java.util.ArrayList;

public class DuplicatedPersonFoundHandler
implements ErrorResponseHandler {
    @Override
    public void Handle(ServiceResponse<Object> serviceResponse) throws FifaDuplicatedPersonFoundException {
        Object body = serviceResponse.body();
        ArrayList<String> ids = new ArrayList<String>();
        if (serviceResponse.response().code() == 409 && body instanceof GetDuplicatesResponseType) {
            GetDuplicatesResponseType responseBody = (GetDuplicatesResponseType)body;
            if (responseBody.duplicates() != null && !responseBody.duplicates().isEmpty()) {
                for (PersonDuplicateType duplicate : responseBody.duplicates()) {
                    ids.add(duplicate.personFifaId());
                }
            }
            throw new FifaDuplicatedPersonFoundException(DuplicateExceptionMessageFormatter.format(ids), responseBody, serviceResponse);
        }
    }
}

