/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.errorhandling;

import com.fifa.connectid.sdk.core.FifaOrganisationMergedException;
import com.fifa.connectid.sdk.core.api.models.OrganisationLocalType;
import com.fifa.connectid.sdk.core.errorhandling.ConnectIdHeaders;
import com.fifa.connectid.sdk.core.errorhandling.ErrorResponseHandler;
import com.microsoft.rest.ServiceResponse;

public class OrganisationMergedExceptionHandler
implements ErrorResponseHandler {
    @Override
    public void Handle(ServiceResponse<Object> serviceResponse) throws FifaOrganisationMergedException {
        OrganisationLocalType requestedOrganisation = null;
        if (serviceResponse.body() instanceof OrganisationLocalType) {
            requestedOrganisation = (OrganisationLocalType)serviceResponse.body();
        }
        String primaryOrganisationId = serviceResponse.response().headers().get(ConnectIdHeaders.mergedInto);
        int responseStatusCode = serviceResponse.response().code();
        if (responseStatusCode == 301 && requestedOrganisation != null && primaryOrganisationId != null) {
            String message = "Service responded with a status code " + responseStatusCode + ". The requested organisation has been merged into " + primaryOrganisationId;
            throw new FifaOrganisationMergedException(primaryOrganisationId, requestedOrganisation, message, serviceResponse);
        }
    }
}

