/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.errorhandling;

import com.fifa.connectid.sdk.core.FifaPersonMergedException;
import com.fifa.connectid.sdk.core.api.models.PersonType;
import com.fifa.connectid.sdk.core.errorhandling.ConnectIdHeaders;
import com.fifa.connectid.sdk.core.errorhandling.ErrorResponseHandler;
import com.microsoft.rest.ServiceResponse;

public class PersonMergedExceptionHandler
implements ErrorResponseHandler {
    @Override
    public void Handle(ServiceResponse<Object> serviceResponse) throws FifaPersonMergedException {
        PersonType requestedPerson = null;
        if (serviceResponse.body() instanceof PersonType) {
            requestedPerson = (PersonType)serviceResponse.body();
        }
        String primaryPersonId = serviceResponse.response().headers().get(ConnectIdHeaders.mergedInto);
        int responseStatusCode = serviceResponse.response().code();
        if (responseStatusCode == 301 && requestedPerson != null && primaryPersonId != null) {
            String message = "Service responded with a status code " + responseStatusCode + ". The requested person has been merged into " + primaryPersonId;
            throw new FifaPersonMergedException(primaryPersonId, requestedPerson, message, serviceResponse);
        }
    }
}

