/*
 * Decompiled with CFR 0.152.
 */
package com.fifa.connectid.sdk.core.iddirectory;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fifa.connectid.sdk.ValidationException;
import com.fifa.connectid.sdk.core.ActorResolver;
import com.fifa.connectid.sdk.core.ConnectIdEnvironment;
import com.fifa.connectid.sdk.core.FifaConflictException;
import com.fifa.connectid.sdk.core.FifaConnectIdException;
import com.fifa.connectid.sdk.core.FifaDuplicatedFacilityFoundException;
import com.fifa.connectid.sdk.core.FifaDuplicatedOrganisationFoundException;
import com.fifa.connectid.sdk.core.FifaEntityNotFoundException;
import com.fifa.connectid.sdk.core.HashedPersonProcessor;
import com.fifa.connectid.sdk.core.InvalidClientDataException;
import com.fifa.connectid.sdk.core.ServiceResponseUtils;
import com.fifa.connectid.sdk.core.UnauthorizedException;
import com.fifa.connectid.sdk.core.api.DataHolders;
import com.fifa.connectid.sdk.core.api.Facilitys;
import com.fifa.connectid.sdk.core.api.Organisations;
import com.fifa.connectid.sdk.core.api.Persons;
import com.fifa.connectid.sdk.core.api.implementation.DataHoldersImpl;
import com.fifa.connectid.sdk.core.api.implementation.FIFAConnectIDIDDirectoryV6Impl;
import com.fifa.connectid.sdk.core.api.implementation.FacilitysImpl;
import com.fifa.connectid.sdk.core.api.implementation.OrganisationsImpl;
import com.fifa.connectid.sdk.core.api.implementation.PersonsImpl;
import com.fifa.connectid.sdk.core.api.models.AddRegistrationsRequestType;
import com.fifa.connectid.sdk.core.api.models.BulkDeactivateRegistrationsRequestType;
import com.fifa.connectid.sdk.core.api.models.BulkDeactivateRegistrationsResponseType;
import com.fifa.connectid.sdk.core.api.models.FacilityLocalType;
import com.fifa.connectid.sdk.core.api.models.FindFacilitiesRequestType;
import com.fifa.connectid.sdk.core.api.models.FindFacilitiesResponseType;
import com.fifa.connectid.sdk.core.api.models.FindOrganisationsRequestType;
import com.fifa.connectid.sdk.core.api.models.FindOrganisationsResponseType;
import com.fifa.connectid.sdk.core.api.models.GetActingOrganisationsResponseType;
import com.fifa.connectid.sdk.core.api.models.GetDuplicatesByFIFAIdRequestType;
import com.fifa.connectid.sdk.core.api.models.GetDuplicatesOfRegisteredPersonResponseType;
import com.fifa.connectid.sdk.core.api.models.GetDuplicatesRequestType;
import com.fifa.connectid.sdk.core.api.models.GetDuplicatesResponseType;
import com.fifa.connectid.sdk.core.api.models.GetFacilityDuplicatesResponseType;
import com.fifa.connectid.sdk.core.api.models.GetOrganisationDuplicatesResponseType;
import com.fifa.connectid.sdk.core.api.models.HashedNameType;
import com.fifa.connectid.sdk.core.api.models.MemberAssociationResponseType;
import com.fifa.connectid.sdk.core.api.models.MergeOrganisationsRequestType;
import com.fifa.connectid.sdk.core.api.models.MergePersonsRequestType;
import com.fifa.connectid.sdk.core.api.models.NationalAssociationsOnboardedRequestType;
import com.fifa.connectid.sdk.core.api.models.NationalAssociationsOnboardedResponseType;
import com.fifa.connectid.sdk.core.api.models.OrganisationLocalType;
import com.fifa.connectid.sdk.core.api.models.PersonType;
import com.fifa.connectid.sdk.core.api.models.RegisterPersonRequestType;
import com.fifa.connectid.sdk.core.api.models.RegisterResponseType;
import com.fifa.connectid.sdk.core.api.models.RegistrationType;
import com.fifa.connectid.sdk.core.api.models.UnmergeOrganisationsRequestType;
import com.fifa.connectid.sdk.core.api.models.UnmergePersonsRequestType;
import com.fifa.connectid.sdk.core.api.models.UpdatePersonRequestType;
import com.fifa.connectid.sdk.core.api.models.UpdateRegistrationsRequestType;
import com.fifa.connectid.sdk.core.apimodelvalidation.ContextTypeValidator;
import com.fifa.connectid.sdk.core.apimodelvalidation.FifaIdValidator;
import com.fifa.connectid.sdk.core.enhancements.ObjectFormatter;
import com.fifa.connectid.sdk.core.errorhandling.ConflictResponseHandler;
import com.fifa.connectid.sdk.core.errorhandling.DuplicateOfRegisteredPersonFoundHandler;
import com.fifa.connectid.sdk.core.errorhandling.DuplicatedFacilityFoundHandler;
import com.fifa.connectid.sdk.core.errorhandling.DuplicatedOrganisationFoundHandler;
import com.fifa.connectid.sdk.core.errorhandling.DuplicatedPersonFoundHandler;
import com.fifa.connectid.sdk.core.errorhandling.EntityDeletedExceptionHandler;
import com.fifa.connectid.sdk.core.errorhandling.ErrorResponseHandler;
import com.fifa.connectid.sdk.core.errorhandling.ExceptionHandlingPolicy;
import com.fifa.connectid.sdk.core.errorhandling.OrganisationMergedExceptionHandler;
import com.fifa.connectid.sdk.core.errorhandling.PersonMergedExceptionHandler;
import com.fifa.connectid.sdk.core.iddirectory.IdDirectoryServiceClient;
import com.fifa.connectid.sdk.core.iddirectory.RegisterPersonRequestProcessor;
import com.fifa.connectid.sdk.core.iddirectory.RegisterPersonRequestProcessorAdapter;
import com.fifa.connectservicebus.sdk.AuthenticationException;
import com.fifa.connectservicebus.sdk.HttpClientFactory;
import com.fifa.connectservicebus.sdk.ProxySettings;
import com.fifa.connectservicebus.sdk.authentication.AuthenticationInterceptor;
import com.fifa.connectservicebus.sdk.authentication.AuthenticationService;
import com.fifa.connectservicebus.sdk.logging.Logger;
import com.microsoft.rest.RestException;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class IdDirectoryServiceClientImpl
implements IdDirectoryServiceClient {
    private final Logger logger;
    private final ActorResolver actorResolver;
    private final Persons personOperations;
    private final Organisations organisationOperations;
    private final Facilitys facilityOperations;
    private final DataHolders dataHoldersOperations;
    private final RegisterPersonRequestProcessor registerPersonRequestProcessor;
    private static int requestTimeoutInSeconds = 60;

    public IdDirectoryServiceClientImpl(Persons personOperations, Organisations organisationOperations, Facilitys facilityOperations, DataHolders dataHoldersOperations, Logger logger, ActorResolver actorResolver, HashedPersonProcessor hashedPersonProcessor) {
        if (personOperations == null) {
            throw new IllegalArgumentException("personOperations parameter cannot be null");
        }
        if (organisationOperations == null) {
            throw new IllegalArgumentException("organisationOperations parameter cannot be null");
        }
        if (facilityOperations == null) {
            throw new IllegalArgumentException("facilityOperations parameter cannot be null");
        }
        if (dataHoldersOperations == null) {
            throw new IllegalArgumentException("dataHoldersOperations parameter cannot be null");
        }
        if (logger == null) {
            throw new IllegalArgumentException("logger parameter cannot be null");
        }
        if (actorResolver == null) {
            throw new IllegalArgumentException("actorResolver parameter cannot be null");
        }
        this.personOperations = personOperations;
        this.organisationOperations = organisationOperations;
        this.facilityOperations = facilityOperations;
        this.dataHoldersOperations = dataHoldersOperations;
        this.logger = logger;
        this.actorResolver = actorResolver;
        this.registerPersonRequestProcessor = new RegisterPersonRequestProcessorAdapter(hashedPersonProcessor);
    }

    public static IdDirectoryServiceClientImpl CreateSyncClient(ConnectIdEnvironment connectIdEnvironment, AuthenticationService authenticationService, Logger logger, ActorResolver actorResolver, ProxySettings proxySettings, HashedPersonProcessor hashedPersonProcessor) {
        Retrofit retrofit = IdDirectoryServiceClientImpl.buildRetrofitClient(connectIdEnvironment, authenticationService, proxySettings);
        FIFAConnectIDIDDirectoryV6Impl fifaConnectIdIdDirectoryV6 = new FIFAConnectIDIDDirectoryV6Impl(connectIdEnvironment.IdDirectoryUrl);
        PersonsImpl personOperations = new PersonsImpl(retrofit, fifaConnectIdIdDirectoryV6);
        OrganisationsImpl organisationOperations = new OrganisationsImpl(retrofit, fifaConnectIdIdDirectoryV6);
        FacilitysImpl facilityOperations = new FacilitysImpl(retrofit, fifaConnectIdIdDirectoryV6);
        DataHoldersImpl dataHoldersOperations = new DataHoldersImpl(retrofit, fifaConnectIdIdDirectoryV6);
        return new IdDirectoryServiceClientImpl(personOperations, organisationOperations, facilityOperations, dataHoldersOperations, logger, actorResolver, hashedPersonProcessor);
    }

    private static Retrofit buildRetrofitClient(ConnectIdEnvironment connectIdEnvironment, AuthenticationService authenticationService, ProxySettings proxySettings) {
        if (connectIdEnvironment == null) {
            throw new IllegalArgumentException("connectIdEnvironment parameter cannot be null");
        }
        if (authenticationService == null) {
            throw new IllegalArgumentException("authenticationService parameter cannot be null");
        }
        OkHttpClient client = HttpClientFactory.create((ProxySettings)proxySettings, (Duration)Duration.ofSeconds(IdDirectoryServiceClientImpl.getRequestTimeoutInSeconds()), builder -> builder.addInterceptor((Interceptor)new AuthenticationInterceptor(authenticationService)));
        ObjectMapper mapper = new ObjectMapper().registerModule(new JodaModule()).setDateFormat(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S"));
        return new Retrofit.Builder().baseUrl(connectIdEnvironment.IdDirectoryUrl).addConverterFactory(JacksonConverterFactory.create(mapper)).client(client).addCallAdapterFactory(RxJavaCallAdapterFactory.create()).build();
    }

    private String resolveActorEncoded() throws UnsupportedEncodingException {
        String actor = this.actorResolver.resolve();
        if (actor == null || actor.isEmpty()) {
            return actor;
        }
        return Base64.getEncoder().encodeToString(actor.getBytes("UTF-8"));
    }

    @Override
    public PersonType getPerson(String personFifaId) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, ValidationException {
        if (personFifaId == null) {
            throw new IllegalArgumentException("personFifaId parameter cannot be null");
        }
        new FifaIdValidator().validate(personFifaId, "personFifaId");
        this.logger.debug("Getting person with the id: " + personFifaId, new Object[0]);
        ServiceResponse result = null;
        try {
            result = this.personOperations.getByPersonfifaidWithServiceResponseAsync(personFifaId).toBlocking().single();
        }
        catch (Exception e) {
            ExceptionHandlingPolicy.handleServiceResponseFailure(e, new FifaConnectIdException("Failed to get person with ID " + personFifaId + " from ID Directory.", e));
        }
        this.logger.debug("Received response from the ID Directory service with status code %d when getting person with id %s", new Object[]{result.response().code(), personFifaId});
        Class<PersonType> clazz = PersonType.class;
        return ServiceResponseUtils.extractResult(result, clazz, 200, new PersonMergedExceptionHandler());
    }

    @Override
    public RegistrationType getPrimaryDataProviderRegistrationType(String personFifaId) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, ValidationException {
        if (personFifaId == null) {
            throw new IllegalArgumentException("personFifaId parameter cannot be null");
        }
        new FifaIdValidator().validate(personFifaId, "personFifaId");
        this.logger.debug("Getting primary data provider registration for person with id: " + personFifaId, new Object[0]);
        ServiceResponse result = null;
        try {
            result = this.personOperations.getPrimaryDataProviderRegistrationByPersonfifaidWithServiceResponseAsync(personFifaId).toBlocking().single();
        }
        catch (Exception e) {
            ExceptionHandlingPolicy.handleServiceResponseFailure(e, new FifaConnectIdException("Failed to get primary data provider registration for person with ID " + personFifaId + " from ID Directory.", e));
        }
        this.logger.debug("Received response from the ID Directory service with status code %d when getting primary data provider registration for person with id %s", new Object[]{result.response().code(), personFifaId});
        Class<RegistrationType> clazz = RegistrationType.class;
        return ServiceResponseUtils.extractResult(result, clazz, 200, new PersonMergedExceptionHandler());
    }

    @Override
    public GetDuplicatesResponseType getPersonDuplicates(GetDuplicatesRequestType request) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, ValidationException {
        if (request == null) {
            throw new IllegalArgumentException("request parameter cannot be null");
        }
        ContextTypeValidator.validate(request, "request");
        this.logger.debug("Getting duplicates for a person: %s", new Object[]{ObjectFormatter.toString(request)});
        ServiceResponse<Object> result = null;
        try {
            result = this.personOperations.getDuplicatesWithServiceResponseAsync(request, this.resolveActorEncoded()).toBlocking().single();
        }
        catch (RestException | IOException e) {
            ExceptionHandlingPolicy.handleServiceResponseFailure(e, new FifaConnectIdException("Failed to get duplicates for person with " + IdDirectoryServiceClientImpl.hashesToMessage(request.nameHashes()), e));
        }
        this.logger.debug("Received response from the ID Directory service with status code %d when getting duplicates for person %s", new Object[]{result.response().code(), ObjectFormatter.toString(request)});
        Class<GetDuplicatesResponseType> clazz = GetDuplicatesResponseType.class;
        return ServiceResponseUtils.extractResult(result, clazz, 200, new ErrorResponseHandler[0]);
    }

    @Override
    public GetDuplicatesOfRegisteredPersonResponseType getPersonDuplicates(GetDuplicatesByFIFAIdRequestType request) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, ValidationException {
        if (request == null) {
            throw new IllegalArgumentException("request parameter cannot be null");
        }
        ContextTypeValidator.validate(request, "request");
        this.logger.debug("Getting duplicates for a person, request: %s", new Object[]{ObjectFormatter.toString(request)});
        ServiceResponse<Object> result = null;
        try {
            result = this.personOperations.getDuplicatesByFIFAIdWithServiceResponseAsync(request, this.resolveActorEncoded()).toBlocking().single();
        }
        catch (IOException e) {
            ExceptionHandlingPolicy.handleServiceResponseFailure(e, new FifaConnectIdException("Failed to get duplicates for person with fifa id " + request.personFIFAId(), e));
        }
        this.logger.debug("Received response from the ID Directory service with status code %d when getting duplicates for person, request: %s", new Object[]{result.response().code(), ObjectFormatter.toString(request)});
        Class<GetDuplicatesOfRegisteredPersonResponseType> clazz = GetDuplicatesOfRegisteredPersonResponseType.class;
        return ServiceResponseUtils.extractResult(result, clazz, 200, new ErrorResponseHandler[0]);
    }

    @Override
    public GetOrganisationDuplicatesResponseType getOrganisationDuplicates(OrganisationLocalType organisation) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, ValidationException {
        if (organisation == null) {
            throw new IllegalArgumentException("organisation parameter cannot be null");
        }
        ContextTypeValidator.validate(organisation, "organisation");
        this.logger.debug("Getting duplicates for an organisation: %s", new Object[]{ObjectFormatter.toString(organisation)});
        ServiceResponse<Object> result = null;
        try {
            result = this.organisationOperations.getDuplicatesWithServiceResponseAsync(organisation, this.resolveActorEncoded()).toBlocking().single();
        }
        catch (IOException e) {
            ExceptionHandlingPolicy.handleServiceResponseFailure(e, new FifaConnectIdException("Failed to get duplicates for organisation " + organisation.organisationFIFAId(), e));
        }
        this.logger.debug("Received response from the ID Directory service with status code %d when getting duplicates for organisation %s", new Object[]{result.response().code(), ObjectFormatter.toString(organisation)});
        Class<GetOrganisationDuplicatesResponseType> clazz = GetOrganisationDuplicatesResponseType.class;
        return ServiceResponseUtils.extractResult(result, clazz, 200, new ErrorResponseHandler[0]);
    }

    @Override
    public GetFacilityDuplicatesResponseType getFacilityDuplicates(FacilityLocalType facility) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, ValidationException {
        if (facility == null) {
            throw new IllegalArgumentException("facility parameter cannot be null");
        }
        ContextTypeValidator.validate(facility, "facility");
        this.logger.debug("Getting duplicates for a facility: %s", new Object[]{ObjectFormatter.toString(facility)});
        ServiceResponse<Object> result = null;
        try {
            result = this.facilityOperations.getDuplicatesWithServiceResponseAsync(facility, this.resolveActorEncoded()).toBlocking().single();
        }
        catch (IOException e) {
            ExceptionHandlingPolicy.handleServiceResponseFailure(e, new FifaConnectIdException("Failed to get duplicates for facility " + facility.organisationFIFAId(), e));
        }
        this.logger.debug("Received response from the ID Directory service with status code %d when getting duplicates for facility %s", new Object[]{result.response().code(), ObjectFormatter.toString(facility)});
        Class<GetFacilityDuplicatesResponseType> clazz = GetFacilityDuplicatesResponseType.class;
        return ServiceResponseUtils.extractResult(result, clazz, 200, new ErrorResponseHandler[0]);
    }

    @Override
    public RegisterResponseType registerPerson(RegisterPersonRequestType request) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, ValidationException {
        if (request == null) {
            throw new IllegalArgumentException("request parameter cannot be null");
        }
        ContextTypeValidator.validate(request, "request");
        this.logger.debug("Registering a person: %s", new Object[]{ObjectFormatter.toString(request)});
        ServiceResponse<Object> result = null;
        try {
            result = this.personOperations.registerWithServiceResponseAsync(this.registerPersonRequestProcessor.process(request), this.resolveActorEncoded()).toBlocking().single();
        }
        catch (IOException e) {
            ExceptionHandlingPolicy.handleServiceResponseFailure(e, new FifaConnectIdException("Failed to register person with " + IdDirectoryServiceClientImpl.hashesToMessage(request.nameHashes()), e));
        }
        this.logger.debug("Received response from the ID Directory service with status code %d when registering person: %s", new Object[]{result.response().code(), ObjectFormatter.toString(request)});
        Class<RegisterResponseType> clazz = RegisterResponseType.class;
        return ServiceResponseUtils.extractResult(result, clazz, 201, new DuplicatedPersonFoundHandler());
    }

    @Override
    public RegisterResponseType forceRegisterPerson(RegisterPersonRequestType request) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, ValidationException {
        if (request == null) {
            throw new IllegalArgumentException("request parameter cannot be null");
        }
        ContextTypeValidator.validate(request, "request");
        this.logger.debug("Force registering a person: %s", new Object[]{ObjectFormatter.toString(request)});
        ServiceResponse<Object> result = null;
        try {
            result = this.personOperations.forceRegisterWithServiceResponseAsync(this.registerPersonRequestProcessor.process(request), this.resolveActorEncoded()).toBlocking().single();
        }
        catch (IOException e) {
            ExceptionHandlingPolicy.handleServiceResponseFailure(e, new FifaConnectIdException("Failed to force register person with " + IdDirectoryServiceClientImpl.hashesToMessage(request.nameHashes()), e));
        }
        this.logger.debug("Received response from the ID Directory service with status code %d when force registering person: %s", new Object[]{result.response().code(), ObjectFormatter.toString(request)});
        Class<RegisterResponseType> clazz = RegisterResponseType.class;
        return ServiceResponseUtils.extractResult(result, clazz, 201, new ErrorResponseHandler[0]);
    }

    @Override
    public PersonType updatePerson(UpdatePersonRequestType request, Boolean force) throws FifaConnectIdException, AuthenticationException, ValidationException {
        if (request == null) {
            throw new IllegalArgumentException("request parameter cannot be null");
        }
        ContextTypeValidator.validate(request, "request");
        this.logger.debug("Updating person with the id: " + request.personId(), new Object[0]);
        ServiceResponse<Object> result = null;
        try {
            result = this.personOperations.updatePersonByForceWithServiceResponseAsync(request, force, this.resolveActorEncoded()).toBlocking().single();
        }
        catch (IOException e) {
            ExceptionHandlingPolicy.handleServiceResponseFailure(e, new FifaConnectIdException("Failed to update person with id " + request.personId(), e));
        }
        this.logger.debug("Received response from the ID Directory service with status code %d when updating person %s", new Object[]{result.response().code(), request.personId()});
        Class<PersonType> clazz = PersonType.class;
        return ServiceResponseUtils.extractResult(result, clazz, 200, new DuplicateOfRegisteredPersonFoundHandler());
    }

    @Override
    public PersonType addRegistrations(AddRegistrationsRequestType request, Boolean force) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, ValidationException {
        if (request == null) {
            throw new IllegalArgumentException("request parameter cannot be null");
        }
        ContextTypeValidator.validate(request, "request");
        this.logger.debug("Adding registration with force: %s for person: %s", new Object[]{force, ObjectFormatter.toString(request)});
        ServiceResponse<Object> result = null;
        try {
            result = this.personOperations.addRegistrationsByForceWithServiceResponseAsync(request, force, this.resolveActorEncoded()).toBlocking().single();
        }
        catch (IOException e) {
            ExceptionHandlingPolicy.handleServiceResponseFailure(e, new FifaConnectIdException("Failed to add registrations for person with ID " + request.personId(), e));
        }
        this.logger.debug("Received response from the ID Directory service with status code %d when adding registartions %s for person %s", new Object[]{result.response().code(), ObjectFormatter.toString(request), request.personId()});
        Class<PersonType> clazz = PersonType.class;
        return ServiceResponseUtils.extractResult(result, clazz, 201, new ErrorResponseHandler[0]);
    }

    @Override
    public PersonType updateRegistrations(UpdateRegistrationsRequestType request, Boolean force) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, ValidationException {
        if (request == null) {
            throw new IllegalArgumentException("request parameter cannot be null");
        }
        ContextTypeValidator.validate(request, "request");
        this.logger.debug("Updating registration with force: %s for request: %s", new Object[]{force.toString(), ObjectFormatter.toString(request)});
        ServiceResponse<Object> result = null;
        try {
            result = this.personOperations.updateRegistrationsByForceWithServiceResponseAsync(request, force, this.resolveActorEncoded()).toBlocking().single();
        }
        catch (IOException e) {
            ExceptionHandlingPolicy.handleServiceResponseFailure(e, new FifaConnectIdException("Failed to update registrations for person with ID " + request.personId(), e));
        }
        this.logger.debug("Received response from the ID Directory service with status %d when updating registrations %s for person %s", new Object[]{result.response().code(), ObjectFormatter.toString(request), request.personId()});
        Class<PersonType> clazz = PersonType.class;
        return ServiceResponseUtils.extractResult(result, clazz, 200, new ErrorResponseHandler[0]);
    }

    @Override
    public BulkDeactivateRegistrationsResponseType bulkDeactivateRegistrations(BulkDeactivateRegistrationsRequestType request) throws FifaConnectIdException, UnauthorizedException, AuthenticationException, InvalidClientDataException, ValidationException {
        if (request == null) {
            throw new IllegalArgumentException("request parameter cannot be null");
        }
        ContextTypeValidator.validate(request, "request");
        this.logger.debug("Bulk deactivating registrations.", new Object[0]);
        ServiceResponse<Object> result = null;
        try {
            result = this.personOperations.bulkDeactivateRegistrationsWithServiceResponseAsync(request, this.resolveActorEncoded()).toBlocking().single();
        }
        catch (IOException e) {
            ExceptionHandlingPolicy.handleServiceResponseFailure(e, new FifaConnectIdException("Failed to bulk deactivate registrations.", e));
        }
        this.logger.debug("Received response from the ID Directory service with status %d when bulk deactivating registrations", new Object[]{result.response().code()});
        Class<BulkDeactivateRegistrationsResponseType> clazz = BulkDeactivateRegistrationsResponseType.class;
        return ServiceResponseUtils.extractResult(result, clazz, 200, new ErrorResponseHandler[0]);
    }

    @Override
    public OrganisationLocalType getOrganisation(String organisationFifaId) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, ValidationException {
        if (organisationFifaId == null) {
            throw new IllegalArgumentException("organisationFifaId parameter cannot be null");
        }
        new FifaIdValidator().validate(organisationFifaId, "organisationFifaId");
        this.logger.debug("Getting organisation with id: " + organisationFifaId, new Object[0]);
        ServiceResponse result = null;
        try {
            result = this.organisationOperations.getByOrganisationfifaidWithServiceResponseAsync(organisationFifaId).toBlocking().single();
        }
        catch (RuntimeException e) {
            ExceptionHandlingPolicy.handleServiceResponseFailure(e, new FifaConnectIdException("Failed to get organisation with ID " + organisationFifaId + " from ID Directory.", e));
        }
        this.logger.debug("Received response from the ID Directory service with status %d when getting organisation %s", new Object[]{result.response().code(), organisationFifaId});
        Class<OrganisationLocalType> clazz = OrganisationLocalType.class;
        return ServiceResponseUtils.extractResult(result, clazz, 200, new OrganisationMergedExceptionHandler());
    }

    @Override
    public OrganisationLocalType mergeOrganisations(String primaryOrganisationFifaId, String secondaryOrganisationFifaId) throws FifaConnectIdException, FifaConflictException, AuthenticationException, UnauthorizedException, ValidationException {
        if (primaryOrganisationFifaId == null) {
            throw new IllegalArgumentException("primaryOrganisationFifaId parameter cannot be null");
        }
        if (secondaryOrganisationFifaId == null) {
            throw new IllegalArgumentException("secondaryOrganisationFifaId parameter cannot be null");
        }
        FifaIdValidator fifaIdValidator = new FifaIdValidator();
        fifaIdValidator.validate(primaryOrganisationFifaId, "primaryOrganisationFifaId");
        fifaIdValidator.validate(secondaryOrganisationFifaId, "secondaryOrganisationFifaId");
        MergeOrganisationsRequestType mergeRequest = new MergeOrganisationsRequestType();
        mergeRequest.withPrimaryOrganisationFIFAId(primaryOrganisationFifaId);
        mergeRequest.withSecondaryOrganisationFIFAId(secondaryOrganisationFifaId);
        this.logger.debug("Merging organisations: " + primaryOrganisationFifaId + " (Primary) and " + secondaryOrganisationFifaId + " (Secondary)", new Object[0]);
        ServiceResponse<Object> result = null;
        try {
            result = this.organisationOperations.mergeWithServiceResponseAsync(mergeRequest, this.resolveActorEncoded()).toBlocking().single();
        }
        catch (IOException e) {
            String message = "Failed to merge organisations: " + primaryOrganisationFifaId + " (Primary) and " + secondaryOrganisationFifaId + " (Secondary)";
            ExceptionHandlingPolicy.handleServiceResponseFailure(e, new FifaConnectIdException(message, e));
        }
        this.logger.debug("Received response from the ID Directory service with status code %d when merging primary organisation %s and secondary organisation %s", new Object[]{result.response().code(), primaryOrganisationFifaId, secondaryOrganisationFifaId});
        Class<OrganisationLocalType> clazz = OrganisationLocalType.class;
        return ServiceResponseUtils.extractResult(result, clazz, 200, new ConflictResponseHandler());
    }

    @Override
    public OrganisationLocalType unmergeOrganisations(String primaryOrganisationFifaId, String secondaryOrganisationFifaId) throws FifaConnectIdException, FifaConflictException, AuthenticationException, UnauthorizedException, ValidationException {
        if (primaryOrganisationFifaId == null) {
            throw new IllegalArgumentException("primaryOrganisationFifaId parameter cannot be null");
        }
        if (secondaryOrganisationFifaId == null) {
            throw new IllegalArgumentException("secondaryOrganisationFifaId parameter cannot be null");
        }
        FifaIdValidator fifaIdValidator = new FifaIdValidator();
        fifaIdValidator.validate(primaryOrganisationFifaId, "primaryOrganisationFifaId");
        fifaIdValidator.validate(secondaryOrganisationFifaId, "secondaryOrganisationFifaId");
        UnmergeOrganisationsRequestType request = new UnmergeOrganisationsRequestType();
        request.withPrimaryOrganisationFIFAId(primaryOrganisationFifaId);
        request.withSecondaryOrganisationFIFAId(secondaryOrganisationFifaId);
        ServiceResponse<Object> result = null;
        try {
            result = this.organisationOperations.unmergeWithServiceResponseAsync(request, this.resolveActorEncoded()).toBlocking().single();
        }
        catch (IOException e) {
            String message = "Failed to unmerge organisations: " + primaryOrganisationFifaId + " (Primary) and " + secondaryOrganisationFifaId + " (Secondary)";
            ExceptionHandlingPolicy.handleServiceResponseFailure(e, new FifaConnectIdException(message, e));
        }
        this.logger.debug("Received response from the ID Directory service with status code %d when unmerging primary organisation %s and secondary organisation %s", new Object[]{result.response().code(), primaryOrganisationFifaId, secondaryOrganisationFifaId});
        Class<OrganisationLocalType> clazz = OrganisationLocalType.class;
        return ServiceResponseUtils.extractResult(result, clazz, 200, new ConflictResponseHandler());
    }

    @Override
    public PersonType mergePersons(String primaryPersonId, String secondaryPersonId) throws FifaConnectIdException, FifaConflictException, AuthenticationException, UnauthorizedException, ValidationException {
        if (primaryPersonId == null) {
            throw new IllegalArgumentException("primaryPersonId parameter cannot be null");
        }
        if (secondaryPersonId == null) {
            throw new IllegalArgumentException("secondaryPersonId parameter cannot be null");
        }
        FifaIdValidator fifaIdValidator = new FifaIdValidator();
        fifaIdValidator.validate(primaryPersonId, "primaryPersonId");
        fifaIdValidator.validate(secondaryPersonId, "secondaryPersonId");
        MergePersonsRequestType requestType = new MergePersonsRequestType();
        requestType.withPrimaryPersonFIFAId(primaryPersonId);
        requestType.withSecondaryPersonFIFAId(secondaryPersonId);
        ServiceResponse<Object> result = null;
        try {
            result = this.personOperations.mergeWithServiceResponseAsync(requestType, this.resolveActorEncoded()).toBlocking().single();
        }
        catch (IOException e) {
            String message = "Failed to merge persons: " + primaryPersonId + " (Primary) and " + secondaryPersonId + " (Secondary)";
            ExceptionHandlingPolicy.handleServiceResponseFailure(e, new FifaConnectIdException(message, e));
        }
        this.logger.debug("Received response from the ID Directory service with status code %d when merging primary person %s and secondary person %s", new Object[]{result.response().code(), primaryPersonId, secondaryPersonId});
        Class<PersonType> clazz = PersonType.class;
        return ServiceResponseUtils.extractResult(result, clazz, 200, new ConflictResponseHandler());
    }

    @Override
    public PersonType unmergePersons(String primaryPersonId, String secondaryPersonId) throws FifaConnectIdException, FifaConflictException, AuthenticationException, UnauthorizedException, ValidationException {
        if (primaryPersonId == null) {
            throw new IllegalArgumentException("primaryPersonId parameter cannot be null");
        }
        if (secondaryPersonId == null) {
            throw new IllegalArgumentException("secondaryPersonId parameter cannot be null");
        }
        FifaIdValidator fifaIdValidator = new FifaIdValidator();
        fifaIdValidator.validate(primaryPersonId, "primaryPersonId");
        fifaIdValidator.validate(secondaryPersonId, "secondaryPersonId");
        UnmergePersonsRequestType request = new UnmergePersonsRequestType();
        request.withPrimaryPersonFIFAId(primaryPersonId);
        request.withSecondaryPersonFIFAId(secondaryPersonId);
        ServiceResponse<Object> result = null;
        try {
            result = this.personOperations.unmergeWithServiceResponseAsync(request, this.resolveActorEncoded()).toBlocking().single();
        }
        catch (IOException e) {
            String message = "Failed to unmerge persons: " + primaryPersonId + " (Primary) and " + secondaryPersonId + " (Secondary)";
            ExceptionHandlingPolicy.handleServiceResponseFailure(e, new FifaConnectIdException(message, e));
        }
        this.logger.debug("Received response from the ID Directory service with status code %d when unmerging primary person %s and secondary person %s", new Object[]{result.response().code(), primaryPersonId, secondaryPersonId});
        Class<PersonType> clazz = PersonType.class;
        return ServiceResponseUtils.extractResult(result, clazz, 200, new ConflictResponseHandler());
    }

    @Override
    public RegisterResponseType registerOrganisation(OrganisationLocalType organisation, Boolean force) throws FifaConnectIdException, AuthenticationException, FifaDuplicatedOrganisationFoundException, UnauthorizedException, ValidationException {
        if (organisation == null) {
            throw new IllegalArgumentException("organisation parameter cannot be null");
        }
        ContextTypeValidator.validate(organisation, "organisation");
        this.logger.debug("Registering an organisation: %s", new Object[]{ObjectFormatter.toString(organisation)});
        ServiceResponse<Object> result = null;
        try {
            result = this.organisationOperations.registerByForceWithServiceResponseAsync(organisation, force, this.resolveActorEncoded()).toBlocking().single();
        }
        catch (IOException e) {
            String message = this.formatFailedOrganisationMessage("Failed to register organisation", organisation);
            ExceptionHandlingPolicy.handleServiceResponseFailure(e, new FifaConnectIdException(message, e));
        }
        this.logger.debug("Received response from the ID Directory service with status %d when registering organisation %s", new Object[]{result.response().code(), ObjectFormatter.toString(organisation)});
        Class<RegisterResponseType> clazz = RegisterResponseType.class;
        return ServiceResponseUtils.extractResult(result, clazz, 201, new DuplicatedOrganisationFoundHandler());
    }

    @Override
    public OrganisationLocalType updateOrganisation(OrganisationLocalType organisation, Boolean force) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, ValidationException {
        if (organisation == null) {
            throw new IllegalArgumentException("organisation parameter cannot be null");
        }
        ContextTypeValidator.validate(organisation, "organisation");
        this.logger.debug("Updating an organisation: %s", new Object[]{ObjectFormatter.toString(organisation)});
        ServiceResponse<Object> result = null;
        try {
            result = this.organisationOperations.updateByForceWithServiceResponseAsync(organisation, force, this.resolveActorEncoded()).toBlocking().single();
        }
        catch (IOException e) {
            String message = this.formatFailedOrganisationMessage("Failed to update organisation", organisation);
            ExceptionHandlingPolicy.handleServiceResponseFailure(e, new FifaConnectIdException(message, e));
        }
        this.logger.debug("Received response from the ID Directory service with status %d when updating organisation %s", new Object[]{result.response().code(), organisation.organisationFIFAId()});
        Class<OrganisationLocalType> clazz = OrganisationLocalType.class;
        return ServiceResponseUtils.extractResult(result, clazz, 200, new DuplicatedOrganisationFoundHandler());
    }

    @Override
    public FacilityLocalType getFacility(String facilityId) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, ValidationException {
        if (facilityId == null) {
            throw new IllegalArgumentException("facilityId parameter cannot be null");
        }
        new FifaIdValidator().validate(facilityId, "facilityId");
        this.logger.debug("Getting facility with id: " + facilityId, new Object[0]);
        ServiceResponse<Object> result = null;
        try {
            result = this.facilityOperations.getByFacilityfifaidWithServiceResponseAsync(facilityId).toBlocking().single();
        }
        catch (RuntimeException e) {
            ExceptionHandlingPolicy.handleServiceResponseFailure(e, new FifaConnectIdException("Failed to get facility with ID " + facilityId + " from ID Directory.", e));
        }
        this.logger.debug("Received response from the ID Directory service with status code %d when getting facility %s", new Object[]{result.response().code(), facilityId});
        Class<FacilityLocalType> clazz = FacilityLocalType.class;
        return ServiceResponseUtils.extractResult(result, clazz, 200, new ErrorResponseHandler[0]);
    }

    @Override
    public RegisterResponseType registerFacility(FacilityLocalType facility, Boolean force) throws FifaConnectIdException, AuthenticationException, FifaDuplicatedFacilityFoundException, UnauthorizedException, ValidationException {
        if (facility == null) {
            throw new IllegalArgumentException("facilityType parameter cannot be null");
        }
        ContextTypeValidator.validate(facility, "facility");
        this.logger.debug("Registering a facility: %s", new Object[]{ObjectFormatter.toString(facility)});
        ServiceResponse<Object> result = null;
        try {
            result = this.facilityOperations.registerByForceWithServiceResponseAsync(facility, force, this.resolveActorEncoded()).toBlocking().single();
        }
        catch (IOException e) {
            String message = this.formatFailedFacilityMessage("Failed to register facility", facility);
            ExceptionHandlingPolicy.handleServiceResponseFailure(e, new FifaConnectIdException(message, e));
        }
        this.logger.debug("Received response from the ID Directory service for register facility with status %d and facility: %s", new Object[]{result.response().code(), ObjectFormatter.toString(facility)});
        Class<RegisterResponseType> clazz = RegisterResponseType.class;
        return ServiceResponseUtils.extractResult(result, clazz, 201, new DuplicatedFacilityFoundHandler());
    }

    @Override
    public FacilityLocalType updateFacility(FacilityLocalType facility, Boolean force) throws FifaConnectIdException, AuthenticationException, UnauthorizedException, ValidationException {
        if (facility == null) {
            throw new IllegalArgumentException("facilityType parameter cannot be null");
        }
        ContextTypeValidator.validate(facility, "facility");
        this.logger.debug("Updating a facility: %s", new Object[]{ObjectFormatter.toString(facility)});
        ServiceResponse<Object> result = null;
        try {
            result = this.facilityOperations.updateByForceWithServiceResponseAsync(facility, force, this.resolveActorEncoded()).toBlocking().single();
        }
        catch (IOException e) {
            String message = this.formatFailedFacilityMessage("Failed to update facility", facility);
            ExceptionHandlingPolicy.handleServiceResponseFailure(e, new FifaConnectIdException(message, e));
        }
        this.logger.debug("Received response from the ID Directory service with status %d when updating facility with id %s", new Object[]{result.response().code(), facility.facilityFIFAId()});
        Class<FacilityLocalType> clazz = FacilityLocalType.class;
        return ServiceResponseUtils.extractResult(result, clazz, 200, new DuplicatedFacilityFoundHandler());
    }

    @Override
    public FindOrganisationsResponseType findOrganisations(FindOrganisationsRequestType request) throws IOException, FifaConnectIdException, AuthenticationException, ValidationException {
        if (request == null) {
            throw new IllegalArgumentException("Request parameter cannot be null.");
        }
        ContextTypeValidator.validate(request, "request");
        this.logger.debug("Searching for organisations: %s", new Object[]{ObjectFormatter.toString(request)});
        ServiceResponse<Object> serverResponse = null;
        try {
            serverResponse = this.organisationOperations.findWithServiceResponseAsync(request, this.resolveActorEncoded()).toBlocking().single();
        }
        catch (IOException e) {
            ExceptionHandlingPolicy.handleServiceResponseFailure(e, new FifaConnectIdException("Failed to find organisations:" + ObjectFormatter.toString(request), e));
        }
        Class<FindOrganisationsResponseType> clazz = FindOrganisationsResponseType.class;
        FindOrganisationsResponseType response = ServiceResponseUtils.extractResult(serverResponse, clazz, 200, new ErrorResponseHandler[0]);
        this.logger.debug("Received response from the ID Directory service: %s", new Object[]{ObjectFormatter.toString(response)});
        return response;
    }

    @Override
    public FindFacilitiesResponseType findFacilities(FindFacilitiesRequestType request) throws IOException, FifaConnectIdException, AuthenticationException, ValidationException {
        if (request == null) {
            throw new IllegalArgumentException("Request parameter cannot be null.");
        }
        ContextTypeValidator.validate(request, "request");
        this.logger.debug("Searching for facilities: %s", new Object[]{ObjectFormatter.toString(request)});
        ServiceResponse<Object> serverResponse = null;
        try {
            serverResponse = this.facilityOperations.findWithServiceResponseAsync(request, this.resolveActorEncoded()).toBlocking().single();
        }
        catch (IOException e) {
            ExceptionHandlingPolicy.handleServiceResponseFailure(e, new FifaConnectIdException("Failed to find facilities:" + ObjectFormatter.toString(request), e));
        }
        Class<FindFacilitiesResponseType> clazz = FindFacilitiesResponseType.class;
        FindFacilitiesResponseType response = ServiceResponseUtils.extractResult(serverResponse, clazz, 200, new ErrorResponseHandler[0]);
        this.logger.debug("Received response from the ID Directory service: %s", new Object[]{ObjectFormatter.toString(response)});
        return response;
    }

    @Override
    public GetActingOrganisationsResponseType getActingOrganisations() throws IOException, FifaConnectIdException {
        this.logger.debug("Getting acting organisations for current user/application", new Object[0]);
        ServiceResponse<Object> response = this.organisationOperations.getActingOrganisationsWithServiceResponseAsync().toBlocking().single();
        this.logger.debug("Received acting organisations for current user/application", new Object[0]);
        Class<GetActingOrganisationsResponseType> clazz = GetActingOrganisationsResponseType.class;
        return ServiceResponseUtils.extractResult(response, clazz, 200, new ErrorResponseHandler[0]);
    }

    @Override
    public NationalAssociationsOnboardedResponseType GetNationalAssociationsOnboardedStatus(NationalAssociationsOnboardedRequestType request) throws UnauthorizedException, FifaEntityNotFoundException, IOException, AuthenticationException, FifaConnectIdException, ValidationException {
        if (request == null || request.nationalAssociationsFifaIds() == null || request.nationalAssociationsFifaIds().isEmpty()) {
            throw new IllegalArgumentException("Request parameter cannot be null or empty.");
        }
        ContextTypeValidator.validate(request, "request");
        this.logger.debug("Checking onboarded status of organisations: `%s`.", new Object[]{StringUtils.join(request.nationalAssociationsFifaIds(), ", ")});
        NationalAssociationsOnboardedResponseType response = this.SendOnboardedStatusRequest(request);
        this.logger.debug("Received response from ID Directory service: %s", new Object[]{StringUtils.join(response.onboardedStatuses(), ", ")});
        return response;
    }

    @Override
    public NationalAssociationsOnboardedResponseType GetAllNationalAssociationsOnboardedStatus() throws UnauthorizedException, IOException, AuthenticationException, FifaConnectIdException {
        this.logger.debug("Checking onboarded status of all national organisations.", new Object[0]);
        NationalAssociationsOnboardedResponseType response = this.SendOnboardedStatusRequest(new NationalAssociationsOnboardedRequestType());
        this.logger.debug("Received response from ID Directory service: %s", new Object[]{StringUtils.join(response.onboardedStatuses(), ", ")});
        return response;
    }

    @Override
    public MemberAssociationResponseType getMemberAssociationForFifaId(String organisationFifaId) throws InvalidClientDataException, FifaEntityNotFoundException, FifaConnectIdException, AuthenticationException, UnauthorizedException, ValidationException {
        if (organisationFifaId == null) {
            throw new IllegalArgumentException("organisationFifaId parameter cannot be null");
        }
        new FifaIdValidator().validate(organisationFifaId, "organisationFifaId");
        this.logger.debug("Getting Member Association for organisationFifaId " + organisationFifaId, new Object[0]);
        ServiceResponse<Object> result = null;
        try {
            result = this.organisationOperations.getMemberAssociationForFifaIdByOrganisationfifaidWithServiceResponseAsync(organisationFifaId).toBlocking().single();
        }
        catch (RuntimeException e) {
            ExceptionHandlingPolicy.handleServiceResponseFailure(e, new FifaConnectIdException("Failed to get Member Association for organisation " + organisationFifaId + " from ID Directory.", e));
        }
        this.logger.debug("Receiving Member Association for organisationFifaId " + organisationFifaId, new Object[0]);
        Class<MemberAssociationResponseType> clazz = MemberAssociationResponseType.class;
        return ServiceResponseUtils.extractResult(result, clazz, 200, new ErrorResponseHandler[0]);
    }

    @Override
    public ArrayList<String> getDataHoldersOfPerson(String personFifaId) throws FifaConnectIdException, AuthenticationException, ValidationException {
        new FifaIdValidator().validate(personFifaId, "personFifaId");
        this.logger.debug("Getting data holders of person " + personFifaId, new Object[0]);
        ServiceResponse<Object> result = null;
        try {
            result = this.dataHoldersOperations.getByPersonfifaidWithServiceResponseAsync(personFifaId).toBlocking().single();
        }
        catch (RuntimeException e) {
            ExceptionHandlingPolicy.handleServiceResponseFailure(e, new FifaConnectIdException("Failed to get data holders for person " + personFifaId + " from ID Directory.", e));
        }
        this.logger.debug("Receiving data holders for person " + personFifaId, new Object[0]);
        Class<?> clazz = new ArrayList().getClass();
        return (ArrayList)ServiceResponseUtils.extractResult(result, clazz, 200, new ErrorResponseHandler[0]);
    }

    @Override
    public void registerAsDataHolderOfPerson(String personFifaId) throws FifaConnectIdException, AuthenticationException, ValidationException {
        new FifaIdValidator().validate(personFifaId, "personFifaId");
        this.logger.debug("Registering as data holder of person " + personFifaId, new Object[0]);
        ServiceResponse<Object> result = null;
        try {
            result = this.dataHoldersOperations.claimByPersonfifaidWithServiceResponseAsync(personFifaId).toBlocking().single();
        }
        catch (RuntimeException e) {
            ExceptionHandlingPolicy.handleServiceResponseFailure(e, new FifaConnectIdException("Failed to register as data holder of person " + personFifaId + " in ID Directory.", e));
        }
        ServiceResponseUtils.handleResponse(result, 202, new PersonMergedExceptionHandler(), new EntityDeletedExceptionHandler());
    }

    @Override
    public List<String> getMergedSecondaryFifaIdsForPerson(String personFifaId) throws ValidationException, AuthenticationException, FifaConnectIdException {
        new FifaIdValidator().validate(personFifaId, "personFifaId");
        this.logger.debug("Getting merged secondary FIFA IDs for person " + personFifaId, new Object[0]);
        ServiceResponse<Object> result = null;
        try {
            result = this.personOperations.getMergedSecondaryFifaIdsByPersonfifaidWithServiceResponseAsync(personFifaId).toBlocking().single();
        }
        catch (RuntimeException e) {
            ExceptionHandlingPolicy.handleServiceResponseFailure(e, new FifaConnectIdException("Failed to get merged secondary FIFA IDs for " + personFifaId + " from ID Directory.", e));
        }
        this.logger.debug("Receiving merged secondary FIFA IDs for person " + personFifaId, new Object[0]);
        Class<?> clazz = new ArrayList().getClass();
        return (List)ServiceResponseUtils.extractResult(result, clazz, 200, new ErrorResponseHandler[0]);
    }

    private NationalAssociationsOnboardedResponseType SendOnboardedStatusRequest(NationalAssociationsOnboardedRequestType request) throws UnauthorizedException, FifaEntityNotFoundException, IOException, AuthenticationException, FifaConnectIdException {
        ServiceResponse<Object> serverResponse = this.organisationOperations.getMemberAssociationsOnboardedStatusWithServiceResponseAsync(request, this.resolveActorEncoded()).toBlocking().single();
        Class<NationalAssociationsOnboardedResponseType> clazz = NationalAssociationsOnboardedResponseType.class;
        NationalAssociationsOnboardedResponseType response = ServiceResponseUtils.extractResult(serverResponse, clazz, 200, new ErrorResponseHandler[0]);
        return response;
    }

    public static int getRequestTimeoutInSeconds() {
        return requestTimeoutInSeconds;
    }

    public static void setRequestTimeoutInSeconds(int requestTimeoutInSeconds) {
        IdDirectoryServiceClientImpl.requestTimeoutInSeconds = requestTimeoutInSeconds;
    }

    private String formatFailedOrganisationMessage(String message, OrganisationLocalType organisation) {
        String organisationName = organisation.internationalName();
        if (StringUtils.isEmpty(organisationName)) {
            organisationName = organisation.internationalShortName();
        }
        if (StringUtils.isEmpty(organisationName)) {
            return message;
        }
        return message + " " + organisationName;
    }

    private String formatFailedFacilityMessage(String message, FacilityLocalType facility) {
        String organisationName = facility.internationalName();
        if (StringUtils.isEmpty(organisationName)) {
            organisationName = facility.internationalShortName();
        }
        if (StringUtils.isEmpty(organisationName)) {
            return message;
        }
        return message + " " + organisationName;
    }

    private static String hashesToMessage(List<HashedNameType> hashes) {
        int count = hashes.size();
        if (count >= 1) {
            return count + " hashes: [" + hashes.get(0) + ", ...].";
        }
        return "0 hashes.";
    }
}

